/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.network;

import java.util.Timer;
import java.util.TimerTask;

public class TaskHandler {
    private Timer timer = new Timer();
    private TimerTask task;
    private Boolean isCancelled = false;

    public void postDelayed(TimerTask timerTask, long delay) {
        this.task = timerTask;
        if (this.isCancelled.booleanValue()) {
            this.recreate();
        }
        this.timer.schedule(timerTask, delay);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long delay, long period) {
        if (this.isCancelled.booleanValue()) {
            this.recreate();
        }
        this.timer.scheduleAtFixedRate(timerTask, delay, period);
    }

    public void removeLast() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void remove(TimerTask task) {
        task.cancel();
    }

    public void cancel() {
        if (!this.isCancelled.booleanValue()) {
            this.removeLast();
            this.timer.cancel();
            this.timer.purge();
            this.isCancelled = true;
        }
    }

    private void recreate() {
        this.timer = new Timer();
        this.isCancelled = false;
    }
}

