/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.network;

import com.rocketchat.common.listener.ConnectListener;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConnectivityManager {
    private ConcurrentLinkedQueue<ConnectListener> listeners = new ConcurrentLinkedQueue();

    ConnectivityManager() {
    }

    public void register(ConnectListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void publishConnect(String sessionId) {
        for (ConnectListener listener : this.listeners) {
            listener.onConnect(sessionId);
        }
    }

    public void publishDisconnect(boolean closedByServer) {
        for (ConnectListener listener : this.listeners) {
            listener.onDisconnect(closedByServer);
        }
    }

    public void publishConnectError(Exception websocketException) {
        for (ConnectListener listener : this.listeners) {
            listener.onConnectError(websocketException);
        }
    }

    public Boolean unRegister(ConnectListener listener) {
        return this.listeners.remove(listener);
    }
}

