/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.data.model;

import com.rocketchat.common.utils.Utils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserObject {
    private String userId;
    protected String userName;
    protected ArrayList<String> roles;
    protected JSONArray emails;
    public static final String ONLINE = "online";
    public static final String OFFLINE = "offline";
    public static final String BUSY = "busy";
    public static final String AWAY = "away";

    public UserObject(JSONObject object) {
        try {
            this.userId = object.optString("_id");
            this.userName = object.getString("username");
            if (object.opt("roles") != null) {
                this.roles = new ArrayList();
                JSONArray array = object.optJSONArray("roles");
                for (int i = 0; i < array.length(); ++i) {
                    this.roles.add(array.getString(i));
                }
            }
            if (object.opt("emails") != null) {
                this.emails = object.optJSONArray("emails");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList<String> roles) {
        this.roles = roles;
    }

    public JSONArray getEmails() {
        return this.emails;
    }

    public String getAvatarUrl() {
        return Utils.getAvatar(this.userName);
    }

    public String toString() {
        return "UserObject{userId='" + this.userId + '\'' + ", userName='" + this.userName + '\'' + ", roles=" + this.roles + ", emails=" + this.emails + '}';
    }

    public static Status getStatus(String s) {
        if (s.equals(ONLINE)) {
            return Status.ONLINE;
        }
        if (s.equals(OFFLINE)) {
            return Status.OFFLINE;
        }
        if (s.equals(BUSY)) {
            return Status.BUSY;
        }
        if (s.equals(AWAY)) {
            return Status.AWAY;
        }
        return Status.OTHER;
    }

    public static enum Status {
        ONLINE,
        BUSY,
        AWAY,
        OFFLINE,
        OTHER;

    }
}

