/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.data.model;

import com.rocketchat.common.data.model.UserObject;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Message {
    private String messageId;
    protected String roomId;
    protected String message;
    private Date msgTimestamp;
    private UserObject sender;
    private Date updatedAt;
    private Date editedAt;
    private UserObject editedBy;
    private String messagetype;
    private String senderAlias;

    public Message(JSONObject object) {
        try {
            this.messageId = object.optString("_id");
            this.roomId = object.optString("rid");
            this.message = object.optString("msg");
            if (object.optJSONObject("ts") != null) {
                this.msgTimestamp = new Date(object.getJSONObject("ts").getLong("$date"));
            }
            this.sender = new UserObject(object.optJSONObject("u"));
            this.updatedAt = new Date(object.getJSONObject("_updatedAt").getLong("$date"));
            if (object.optJSONObject("editedAt") != null) {
                this.editedAt = new Date(object.getJSONObject("editedAt").getLong("$date"));
                this.editedBy = new UserObject(object.getJSONObject("editedBy"));
            }
            this.messagetype = object.optString("t");
            this.senderAlias = object.optString("alias");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getMsgTimestamp() {
        return this.msgTimestamp;
    }

    public UserObject getSender() {
        return this.sender;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Date getEditedAt() {
        return this.editedAt;
    }

    public UserObject getEditedBy() {
        return this.editedBy;
    }

    public String getMessagetype() {
        return this.messagetype;
    }

    public String getSenderAlias() {
        return this.senderAlias;
    }
}

