/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.data.lightdb.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Collection<T, K> {
    ConcurrentHashMap<T, K> documents = new ConcurrentHashMap();
    ConcurrentHashMap<T, Observer<K>> observers = new ConcurrentHashMap();

    public void add(T key, K value) {
        this.documents.put(key, value);
        this.publish(Type.ADDED, key, value);
    }

    public K get(T key) {
        return this.documents.get(key);
    }

    public void update(T key, K newValue) {
        this.publish(Type.CHANGED, key, newValue);
    }

    public K remove(T key) {
        K value = this.documents.remove(key);
        this.publish(Type.REMOVED, key, value);
        return value;
    }

    public List<K> getData() {
        ArrayList<K> list = new ArrayList<K>();
        Set<Map.Entry<T, K>> set = this.documents.entrySet();
        for (Map.Entry<T, K> entry : set) {
            list.add(entry.getValue());
        }
        return list;
    }

    public void removeAll() {
        this.documents.clear();
    }

    public void register(T key, Observer<K> o) {
        this.observers.put(key, o);
    }

    public void unRegister(T key) {
        this.observers.remove(key);
    }

    private void publish(Type type, T key, K document) {
        if (this.observers.containsKey(key)) {
            this.observers.get(key).onUpdate(type, document);
        }
    }

    public void unRegisterAll() {
        this.observers.clear();
    }

    public static interface Observer<K> {
        public void onUpdate(Type var1, K var2);
    }

    public static enum Type {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

