/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.data.lightdb;

import com.rocketchat.common.data.lightdb.collection.Collection;
import com.rocketchat.common.data.lightdb.document.UserDocument;
import com.rocketchat.common.data.rpc.RPC;
import java.util.Observable;
import org.json.JSONObject;

public class DbManager
extends Observable {
    private Collection<String, UserDocument> usersCollection = new Collection();
    private static final String COLLECTION_TYPE_USERS = "users";
    private static final String COLLECTION_TYPE_METEOR_ACCOUNTS_LOGIN_CONF = "meteor_accounts_loginServiceConfiguration";
    private static final String COLLECTION_TYPE_ROCKETCHAT_ROLES = "rocketchat_roles";
    private static final String COLLECTION_TYPE_METEOR_CLIENT_VERSIONS = "meteor_autoupdate_clientVersions";

    public Collection<String, UserDocument> getUserCollection() {
        return this.usersCollection;
    }

    public void update(JSONObject object, RPC.MsgType type) {
        String collectionName = object.optString("collection");
        if (collectionName.equals(COLLECTION_TYPE_USERS)) {
            this.updateUsers(object, type);
        }
    }

    private void updateUsers(JSONObject object, RPC.MsgType type) {
        String id = object.optString("id");
        switch (type) {
            case ADDED: {
                UserDocument userDocument = new UserDocument(object.optJSONObject("fields"));
                userDocument.setUserId(id);
                this.usersCollection.add(id, userDocument);
                this.setChanged();
                this.notifyObservers(userDocument);
                break;
            }
            case CHANGED: {
                this.usersCollection.get(id).update(object.optJSONObject("fields"));
                UserDocument document = this.usersCollection.get(id);
                this.usersCollection.update(id, document);
                this.setChanged();
                this.notifyObservers(document);
                break;
            }
            case REMOVED: {
                this.usersCollection.remove(id);
                this.setChanged();
                this.notifyObservers();
                break;
            }
            case OTHER: {
                break;
            }
        }
    }

    public static Type getCollectionType(JSONObject object) {
        String collectionName = object.optString("collection");
        if (collectionName.equals(COLLECTION_TYPE_USERS) || collectionName.equals(COLLECTION_TYPE_METEOR_ACCOUNTS_LOGIN_CONF) || collectionName.equals(COLLECTION_TYPE_METEOR_CLIENT_VERSIONS) || collectionName.equals(COLLECTION_TYPE_ROCKETCHAT_ROLES)) {
            return Type.COLLECTION;
        }
        return Type.STREAM_COLLECTION;
    }

    public static enum Type {
        STREAM_COLLECTION,
        COLLECTION;

    }
}

