/*
 * Decompiled with CFR 0.152.
 */
package com.github.baloise.rocketchatrestclient;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.baloise.rocketchatrestclient.RocketChatClientResponse;
import com.github.baloise.rocketchatrestclient.RocketChatQueryParams;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.json.JSONObject;

public class RocketChatClientCallBuilder {
    public static final String CALL_METHOD_NAME_ARGUMENTS_KEY = "methodNameArgs";
    private final ObjectMapper objectMapper;
    private final String serverUrl;
    private final String user;
    private final String password;
    private String authToken;
    private String userId;

    protected RocketChatClientCallBuilder(String serverUrl, String user, String password) {
        this.serverUrl = serverUrl.endsWith("/") ? serverUrl + (serverUrl.endsWith("api/") ? "" : "api/") : serverUrl + (serverUrl.endsWith("api") ? "/" : "/api/");
        this.user = user;
        this.password = password;
        this.authToken = "";
        this.userId = "";
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected RocketChatClientResponse buildCall(RocketChatRestApiV1 call) throws IOException {
        return this.buildCall(call, null, null);
    }

    protected RocketChatClientResponse buildCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams) throws IOException {
        return this.buildCall(call, queryParams, null);
    }

    protected RocketChatClientResponse buildCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams, Object body) throws IOException {
        if (call.requiresAuth() && (this.authToken.isEmpty() || this.userId.isEmpty())) {
            this.login();
        }
        switch (call.getHttpMethod()) {
            case GET: {
                return this.buildGetCall(call, queryParams);
            }
            case POST: {
                return this.buildPostCall(call, queryParams, body);
            }
        }
        throw new IOException("Http Method " + call.getHttpMethod().toString() + " is not supported.");
    }

    protected void logout() throws IOException {
        try {
            Unirest.post(this.serverUrl + "v1/logout").asString();
            this.authToken = "";
            this.userId = "";
        }
        catch (UnirestException e) {
            throw new IOException(e);
        }
    }

    private void login() throws IOException {
        HttpResponse<JsonNode> loginResult;
        try {
            loginResult = Unirest.post(this.serverUrl + "v1/login").field("username", this.user).field("password", this.password).asJson();
        }
        catch (UnirestException e) {
            throw new IOException(e);
        }
        if (loginResult.getStatus() == 401) {
            throw new IOException("The username and password provided are incorrect.");
        }
        if (loginResult.getStatus() != 200) {
            throw new IOException("The login failed with a result of: " + loginResult.getStatus() + " (" + loginResult.getStatusText() + ")");
        }
        JSONObject data = loginResult.getBody().getObject().getJSONObject("data");
        this.authToken = data.getString("authToken");
        this.userId = data.getString("userId");
    }

    private RocketChatClientResponse buildGetCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams) throws IOException {
        String methodName = this.prepareCallMethodName(call, queryParams);
        GetRequest req = Unirest.get(this.serverUrl + methodName);
        if (call.requiresAuth()) {
            req.header("X-Auth-Token", this.authToken);
            req.header("X-User-Id", this.userId);
        }
        if (queryParams != null && queryParams.get() != null && !queryParams.isEmpty()) {
            for (Map.Entry<? extends String, ? extends String> e : queryParams.get().entrySet()) {
                req.queryString(e.getKey(), e.getValue());
            }
        }
        try {
            HttpResponse<String> res = req.asString();
            return this.objectMapper.readValue(res.getBody(), RocketChatClientResponse.class);
        }
        catch (UnirestException e) {
            throw new IOException(e);
        }
    }

    private RocketChatClientResponse buildPostCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams, Object body) throws IOException {
        String methodName = this.prepareCallMethodName(call, queryParams);
        HttpRequestWithBody req = Unirest.post(this.serverUrl + methodName).header("Content-Type", "application/json");
        if (call.requiresAuth()) {
            req.header("X-Auth-Token", this.authToken);
            req.header("X-User-Id", this.userId);
        }
        if (queryParams != null && queryParams.get() != null && !queryParams.isEmpty()) {
            for (Map.Entry<? extends String, ? extends String> e : queryParams.get().entrySet()) {
                req.queryString(e.getKey(), e.getValue());
            }
        }
        if (body != null) {
            req.body(this.objectMapper.writeValueAsString(body));
        }
        try {
            HttpResponse<String> res = req.asString();
            return this.objectMapper.readValue(res.getBody(), RocketChatClientResponse.class);
        }
        catch (UnirestException e) {
            throw new IOException(e);
        }
    }

    private String prepareCallMethodName(RocketChatRestApiV1 call, RocketChatQueryParams queryParams) {
        String methodName = call.getMethodName();
        if (methodName.contains("{") && methodName.contains("}")) {
            String[] methodArguments = queryParams.get().get(CALL_METHOD_NAME_ARGUMENTS_KEY).split(",");
            methodName = MessageFormat.format(methodName, methodArguments);
            queryParams.get().remove(CALL_METHOD_NAME_ARGUMENTS_KEY);
        } else {
            methodName = call.getMethodName();
        }
        return methodName;
    }
}

