/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics;

import io.intino.magritte.lang.semantics.Assumption;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.Documentation;
import io.intino.magritte.lang.semantics.constraints.ConstraintHelper;
import io.intino.magritte.lang.semantics.constraints.RuleFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Context {
    private final String[] types;
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final List<Assumption> assumptions = new ArrayList<Assumption>();
    private Documentation documentation;

    public Context(String[] types, Constraint[] globalConstrains) {
        this.types = (String[])types.clone();
        Collections.addAll(this.constraints, globalConstrains);
    }

    public String[] types() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    public List<Assumption> assumptions() {
        return this.assumptions;
    }

    public Documentation doc() {
        return this.documentation;
    }

    public Context doc(String layer, String file, int line, String doc) {
        this.documentation = new Documentation(layer, file, line, doc);
        return this;
    }

    public Context assume(Assumption ... assumptions) {
        this.assumptions.addAll(Arrays.asList(assumptions));
        return this;
    }

    public Context has(Constraint ... constraints) {
        this.constraints().addAll(Arrays.asList(constraints));
        return this.rejectOthers();
    }

    private Context rejectOthers() {
        this.constraints().add(RuleFactory.rejectOtherComponents(ConstraintHelper.componentConstrains(this.constraints())));
        this.constraints().add(RuleFactory.rejectOtherParameters(ConstraintHelper.parameterConstrains(this.constraints())));
        this.constraints().add(RuleFactory.rejectOtherAspects(ConstraintHelper.facetConstrains(this.constraints())));
        return this;
    }
}

