/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.functions.FitsNewProcess;
import io.intino.cesar.graph.functions.FitsProcessChange;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ServerConsul
extends Consul
implements Component,
Terminal {
    protected int jmxPort;
    protected Expression<String> url;
    protected List<Process> processes = new ArrayList<Process>();
    protected FitsNewProcess fitsNew;
    protected FitsProcessChange fits;
    protected Expression<Boolean> isAlive;

    public ServerConsul(Node node) {
        super(node);
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public String url() {
        return this.url.value();
    }

    public List<Process> processes() {
        return this.processes;
    }

    public Process processes(int index) {
        return this.processes.get(index);
    }

    public List<Process> processes(Predicate<Process> predicate) {
        return this.processes().stream().filter(predicate).collect(Collectors.toList());
    }

    public boolean fitsNew(int memory, double hdd) {
        return this.fitsNew.fits(memory, hdd);
    }

    public boolean fits(Process process, int newMemory, double newHdd) {
        return this.fits.fits(process, newMemory, newHdd);
    }

    public Boolean isAlive() {
        return this.isAlive.value();
    }

    public ServerConsul jmxPort(int value) {
        this.jmxPort = value;
        return this;
    }

    public ServerConsul url(Expression<String> value) {
        this.url = FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("jmxPort", new ArrayList<Integer>(Collections.singletonList(this.jmxPort)));
        map.put("url", new ArrayList<Expression<String>>(Collections.singletonList(this.url)));
        map.put("processes", this.processes);
        map.put("fitsNew", this.fitsNew != null ? new ArrayList<FitsNewProcess>(Collections.singletonList(this.fitsNew)) : Collections.emptyList());
        map.put("fits", this.fits != null ? new ArrayList<FitsProcessChange>(Collections.singletonList(this.fits)) : Collections.emptyList());
        map.put("isAlive", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isAlive)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("processes")) {
            this.processes = NodeLoader.load(values, Process.class, this);
        } else if (name.equalsIgnoreCase("fitsNew")) {
            this.fitsNew = FunctionLoader.load(values, (Layer)this, FitsNewProcess.class).get(0);
        } else if (name.equalsIgnoreCase("fits")) {
            this.fits = FunctionLoader.load(values, (Layer)this, FitsProcessChange.class).get(0);
        } else if (name.equalsIgnoreCase("isAlive")) {
            this.isAlive = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("processes")) {
            this.processes = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Process.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("fitsNew")) {
            this.fitsNew = FunctionLoader.load(values.get(0), (Layer)this, FitsNewProcess.class);
        } else if (name.equalsIgnoreCase("fits")) {
            this.fits = FunctionLoader.load(values.get(0), (Layer)this, FitsProcessChange.class);
        } else if (name.equalsIgnoreCase("isAlive")) {
            this.isAlive = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        }
    }

    @Override
    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }
}

