/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.Status;
import io.intino.magritte.framework.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Server
extends AbstractServer {
    private ServerStatus current;

    public Server(Node node) {
        super(node);
    }

    @Override
    public ServerStatus currentStatus() {
        return this.current;
    }

    public synchronized List<ServerStatus> serverStatusList() {
        ArrayList<ServerStatus> serverStatuses = new ArrayList<ServerStatus>(this.graph().serverStatusList());
        return serverStatuses.stream().filter(p -> p.core$().id().startsWith(this.statusStash())).collect(Collectors.toList());
    }

    public void add(io.intino.cesar.datahub.events.consul.server.ServerStatus status) {
        this.current = this.graph().create(this.statusStash()).serverStatus(status.ts(), status.cpu(), status.memory(), status.hdd(), status.inboundConnections(), status.outboundConnections(), status.kernelTemperature(), status.temperature());
        if (this.graph().processStatusList().size() > this.graph().configuration().historySize()) {
            this.graph().processStatusList().get(0).delete$();
        }
    }

    @Override
    public boolean isCompromised() {
        return this.isDisconnected() || this.isRunningOutOfDisk() || this.isRunningOutOfMemory();
    }

    @Override
    public boolean isDisconnected() {
        ServerStatus status = this.currentStatus();
        return status == null || status.ts().until(Instant.now(), ChronoUnit.MINUTES) > (long)this.graph().configuration().serverDisconnectedTimeThreshold;
    }

    @Override
    public boolean isRunningOutOfDisk() {
        ServerStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.diskUsage() > 90.0;
    }

    public boolean isRunningOutOfMemory() {
        ServerStatus status = this.currentStatus();
        if (this.status == null) {
            return false;
        }
        return status.memoryUsage() > 90.0;
    }

    public boolean isHot() {
        ServerStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.kernelTemperature() >= (double)this.graph().configuration().serverKernelTemperatureThreshold();
    }

    public boolean isCpuFull() {
        int count = 0;
        for (Status status : this.serverStatusList()) {
            if (!(status.a$(ServerStatus.class).cpuUsage > 98.0)) continue;
            ++count;
        }
        return (double)count > (double)this.serverStatusList().size() * 0.8;
    }

    private String statusStash() {
        return "status/" + this.name$();
    }

    public static class HDD
    extends AbstractServer.AbstractHDD {
        public HDD(Node node) {
            super(node);
        }
    }

    public static class CPU
    extends AbstractServer.AbstractCPU {
        public CPU(Node node) {
            super(node);
        }
    }

    public static class Memory
    extends AbstractServer.AbstractMemory {
        public Memory(Node node) {
            super(node);
        }
    }

    public static class RemoteConnection
    extends AbstractServer.AbstractRemoteConnection {
        public RemoteConnection(Node node) {
            super(node);
        }
    }
}

