/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Status;
import io.intino.cesar.graph.User;
import io.intino.cesar.graph.rules.IssueType;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class Perceptible
extends Layer
implements Terminal {
    protected String label;
    protected List<IssueType> activeIssueSensors = new ArrayList<IssueType>();
    protected List<IssueType> currentIssues = new ArrayList<IssueType>();
    protected List<User> responsibles = new ArrayList<User>();
    protected List<Status> status = new ArrayList<Status>();
    protected String type;

    public Perceptible(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public List<IssueType> activeIssueSensors() {
        return this.activeIssueSensors;
    }

    public List<IssueType> currentIssues() {
        return this.currentIssues;
    }

    public List<User> responsibles() {
        return this.responsibles;
    }

    public User responsibles(int index) {
        return this.responsibles.get(index);
    }

    public List<User> responsibles(Predicate<User> predicate) {
        return this.responsibles().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Status> status() {
        return this.status;
    }

    public Status status(int index) {
        return this.status.get(index);
    }

    public List<Status> status(Predicate<Status> predicate) {
        return this.status().stream().filter(predicate).collect(Collectors.toList());
    }

    public String type() {
        return this.type;
    }

    public Perceptible label(String value) {
        this.label = value;
        return this;
    }

    public Perceptible activeIssueSensors(List<IssueType> values) {
        this.activeIssueSensors = values;
        return this;
    }

    public Perceptible currentIssues(List<IssueType> values) {
        this.currentIssues = values;
        return this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("activeIssueSensors", this.activeIssueSensors);
        map.put("currentIssues", this.currentIssues);
        map.put("responsibles", this.responsibles);
        map.put("status", this.status);
        map.put("type", new ArrayList<String>(Collections.singletonList(this.type)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("activeIssueSensors")) {
            this.activeIssueSensors = WordLoader.load(values, IssueType.class, this);
        } else if (name.equalsIgnoreCase("currentIssues")) {
            this.currentIssues = WordLoader.load(values, IssueType.class, this);
        } else if (name.equalsIgnoreCase("responsibles")) {
            this.responsibles = NodeLoader.load(values, User.class, this);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = NodeLoader.load(values, Status.class, this);
        } else if (name.equalsIgnoreCase("type")) {
            this.type = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("activeIssueSensors")) {
            this.activeIssueSensors = new ArrayList(values);
        } else if (name.equalsIgnoreCase("currentIssues")) {
            this.currentIssues = new ArrayList(values);
        } else if (name.equalsIgnoreCase("responsibles")) {
            this.responsibles = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(User.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("status")) {
            this.status = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Status.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("type")) {
            this.type = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

