/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.functions.PortRelease;
import io.intino.cesar.graph.functions.PortReservation;
import io.intino.cesar.graph.rules.IssueType;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractServer
extends Asset
implements Terminal {
    protected List<IssueType> activeIssueSensors = new ArrayList<IssueType>();
    protected String ip;
    protected String architecture;
    protected String os;
    protected String jvm;
    protected String appsWorkspace;
    protected Scope scope;
    protected List<Integer> debugUsedPorts = new ArrayList<Integer>();
    protected List<Integer> jmxUsedPorts = new ArrayList<Integer>();
    protected PortReservation reserveDebugPort;
    protected PortReservation reserveJMXPort;
    protected PortRelease releasePort;
    protected ServerConsul serverConsul;
    protected List<Process> processList = new ArrayList<Process>();
    protected Server.RemoteConnection remoteConnection;
    protected Server.Memory memory;
    protected Server.CPU cPU;
    protected Server.HDD hDD;

    public AbstractServer(Node node) {
        super(node);
    }

    public String ip() {
        return this.ip;
    }

    public String architecture() {
        return this.architecture;
    }

    public String os() {
        return this.os;
    }

    public String jvm() {
        return this.jvm;
    }

    public String appsWorkspace() {
        return this.appsWorkspace;
    }

    public Scope scope() {
        return this.scope;
    }

    public List<Integer> debugUsedPorts() {
        return this.debugUsedPorts;
    }

    public Integer debugUsedPorts(int index) {
        return this.debugUsedPorts.get(index);
    }

    public List<Integer> debugUsedPorts(Predicate<Integer> predicate) {
        return this.debugUsedPorts().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Integer> jmxUsedPorts() {
        return this.jmxUsedPorts;
    }

    public Integer jmxUsedPorts(int index) {
        return this.jmxUsedPorts.get(index);
    }

    public List<Integer> jmxUsedPorts(Predicate<Integer> predicate) {
        return this.jmxUsedPorts().stream().filter(predicate).collect(Collectors.toList());
    }

    public int reserveDebugPort() {
        return this.reserveDebugPort.reservePort();
    }

    public int reserveJMXPort() {
        return this.reserveJMXPort.reservePort();
    }

    public void releasePort(int port) {
        this.releasePort.release(port);
    }

    public Server ip(String value) {
        this.ip = value;
        return (Server)this;
    }

    public Server architecture(String value) {
        this.architecture = value;
        return (Server)this;
    }

    public Server os(String value) {
        this.os = value;
        return (Server)this;
    }

    public Server jvm(String value) {
        this.jvm = value;
        return (Server)this;
    }

    public Server appsWorkspace(String value) {
        this.appsWorkspace = value;
        return (Server)this;
    }

    public Server scope(Scope value) {
        this.scope = value;
        return (Server)this;
    }

    public Server reserveDebugPort(PortReservation value) {
        this.reserveDebugPort = FunctionLoader.load(this.reserveDebugPort, (Layer)this, PortReservation.class);
        return (Server)this;
    }

    public Server reserveJMXPort(PortReservation value) {
        this.reserveJMXPort = FunctionLoader.load(this.reserveJMXPort, (Layer)this, PortReservation.class);
        return (Server)this;
    }

    public Server releasePort(PortRelease value) {
        this.releasePort = FunctionLoader.load(this.releasePort, (Layer)this, PortRelease.class);
        return (Server)this;
    }

    public ServerConsul serverConsul() {
        return this.serverConsul;
    }

    public List<Process> processList() {
        return Collections.unmodifiableList(this.processList);
    }

    public Process process(int index) {
        return this.processList.get(index);
    }

    public List<Process> processList(Predicate<Process> predicate) {
        return this.processList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Process process(Predicate<Process> predicate) {
        return this.processList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Server.RemoteConnection remoteConnection() {
        return this.remoteConnection;
    }

    public Server.Memory memory() {
        return this.memory;
    }

    public Server.CPU cPU() {
        return this.cPU;
    }

    public Server.HDD hDD() {
        return this.hDD;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.serverConsul != null) {
            components.add(this.serverConsul.core$());
        }
        new ArrayList<Process>(this.processList).forEach(c -> components.add(c.core$()));
        if (this.remoteConnection != null) {
            components.add(this.remoteConnection.core$());
        }
        if (this.memory != null) {
            components.add(this.memory.core$());
        }
        if (this.cPU != null) {
            components.add(this.cPU.core$());
        }
        if (this.hDD != null) {
            components.add(this.hDD.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("ip", new ArrayList<String>(Collections.singletonList(this.ip)));
        map.put("architecture", new ArrayList<String>(Collections.singletonList(this.architecture)));
        map.put("os", new ArrayList<String>(Collections.singletonList(this.os)));
        map.put("jvm", new ArrayList<String>(Collections.singletonList(this.jvm)));
        map.put("appsWorkspace", new ArrayList<String>(Collections.singletonList(this.appsWorkspace)));
        map.put("scope", new ArrayList<Scope>(Collections.singletonList(this.scope)));
        map.put("debugUsedPorts", this.debugUsedPorts);
        map.put("jmxUsedPorts", this.jmxUsedPorts);
        map.put("reserveDebugPort", this.reserveDebugPort != null ? new ArrayList<PortReservation>(Collections.singletonList(this.reserveDebugPort)) : Collections.emptyList());
        map.put("reserveJMXPort", this.reserveJMXPort != null ? new ArrayList<PortReservation>(Collections.singletonList(this.reserveJMXPort)) : Collections.emptyList());
        map.put("releasePort", this.releasePort != null ? new ArrayList<PortRelease>(Collections.singletonList(this.releasePort)) : Collections.emptyList());
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = node.as(ServerConsul.class);
        }
        if (node.is("Process")) {
            this.processList.add(node.as(Process.class));
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = node.as(Server.RemoteConnection.class);
        }
        if (node.is("Server$Memory")) {
            this.memory = node.as(Server.Memory.class);
        }
        if (node.is("Server$CPU")) {
            this.cPU = node.as(Server.CPU.class);
        }
        if (node.is("Server$HDD")) {
            this.hDD = node.as(Server.HDD.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = null;
        }
        if (node.is("Process")) {
            this.processList.remove(node.as(Process.class));
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = null;
        }
        if (node.is("Server$Memory")) {
            this.memory = null;
        }
        if (node.is("Server$CPU")) {
            this.cPU = null;
        }
        if (node.is("Server$HDD")) {
            this.hDD = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("ip")) {
            this.ip = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("architecture")) {
            this.architecture = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("os")) {
            this.os = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("jvm")) {
            this.jvm = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("appsWorkspace")) {
            this.appsWorkspace = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("scope")) {
            this.scope = WordLoader.load(values, Scope.class, this).get(0);
        } else if (name.equalsIgnoreCase("debugUsedPorts")) {
            this.debugUsedPorts = IntegerLoader.load(values, this);
        } else if (name.equalsIgnoreCase("jmxUsedPorts")) {
            this.jmxUsedPorts = IntegerLoader.load(values, this);
        } else if (name.equalsIgnoreCase("reserveDebugPort")) {
            this.reserveDebugPort = FunctionLoader.load(values, (Layer)this, PortReservation.class).get(0);
        } else if (name.equalsIgnoreCase("reserveJMXPort")) {
            this.reserveJMXPort = FunctionLoader.load(values, (Layer)this, PortReservation.class).get(0);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = FunctionLoader.load(values, (Layer)this, PortRelease.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("ip")) {
            this.ip = (String)values.get(0);
        } else if (name.equalsIgnoreCase("architecture")) {
            this.architecture = (String)values.get(0);
        } else if (name.equalsIgnoreCase("os")) {
            this.os = (String)values.get(0);
        } else if (name.equalsIgnoreCase("jvm")) {
            this.jvm = (String)values.get(0);
        } else if (name.equalsIgnoreCase("appsWorkspace")) {
            this.appsWorkspace = (String)values.get(0);
        } else if (name.equalsIgnoreCase("scope")) {
            this.scope = (Scope)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("debugUsedPorts")) {
            this.debugUsedPorts = new ArrayList(values);
        } else if (name.equalsIgnoreCase("jmxUsedPorts")) {
            this.jmxUsedPorts = new ArrayList(values);
        } else if (name.equalsIgnoreCase("reserveDebugPort")) {
            this.reserveDebugPort = FunctionLoader.load(values.get(0), (Layer)this, PortReservation.class);
        } else if (name.equalsIgnoreCase("reserveJMXPort")) {
            this.reserveJMXPort = FunctionLoader.load(values.get(0), (Layer)this, PortReservation.class);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = FunctionLoader.load(values.get(0), (Layer)this, PortRelease.class);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }

    public static abstract class AbstractHDD
    extends Layer
    implements Component,
    Terminal {
        protected double capacity;
        protected int frequency;
        protected boolean raid;

        public AbstractHDD(Node node) {
            super(node);
        }

        public double capacity() {
            return this.capacity;
        }

        public int frequency() {
            return this.frequency;
        }

        public boolean raid() {
            return this.raid;
        }

        public Server.HDD capacity(double value) {
            this.capacity = value;
            return (Server.HDD)this;
        }

        public Server.HDD frequency(int value) {
            this.frequency = value;
            return (Server.HDD)this;
        }

        public Server.HDD raid(boolean value) {
            this.raid = value;
            return (Server.HDD)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("capacity", new ArrayList<Double>(Collections.singletonList(this.capacity)));
            map.put("frequency", new ArrayList<Integer>(Collections.singletonList(this.frequency)));
            map.put("raid", new ArrayList<Boolean>(Collections.singletonList(this.raid)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("capacity")) {
                this.capacity = DoubleLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = IntegerLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("raid")) {
                this.raid = BooleanLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("capacity")) {
                this.capacity = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("raid")) {
                this.raid = (Boolean)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public static abstract class AbstractCPU
    extends Layer
    implements Component,
    Terminal {
        protected int cores;
        protected double frequency;

        public AbstractCPU(Node node) {
            super(node);
        }

        public int cores() {
            return this.cores;
        }

        public double frequency() {
            return this.frequency;
        }

        public Server.CPU cores(int value) {
            this.cores = value;
            return (Server.CPU)this;
        }

        public Server.CPU frequency(double value) {
            this.frequency = value;
            return (Server.CPU)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("cores", new ArrayList<Integer>(Collections.singletonList(this.cores)));
            map.put("frequency", new ArrayList<Double>(Collections.singletonList(this.frequency)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("cores")) {
                this.cores = IntegerLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = DoubleLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("cores")) {
                this.cores = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = (Double)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public static abstract class AbstractMemory
    extends Layer
    implements Component,
    Terminal {
        protected double capacity;
        protected double frequency;

        public AbstractMemory(Node node) {
            super(node);
        }

        public double capacity() {
            return this.capacity;
        }

        public double frequency() {
            return this.frequency;
        }

        public Server.Memory capacity(double value) {
            this.capacity = value;
            return (Server.Memory)this;
        }

        public Server.Memory frequency(double value) {
            this.frequency = value;
            return (Server.Memory)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("capacity", new ArrayList<Double>(Collections.singletonList(this.capacity)));
            map.put("frequency", new ArrayList<Double>(Collections.singletonList(this.frequency)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("capacity")) {
                this.capacity = DoubleLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = DoubleLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("capacity")) {
                this.capacity = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("frequency")) {
                this.frequency = (Double)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public static abstract class AbstractRemoteConnection
    extends Layer
    implements Terminal {
        protected String user;
        protected String url;
        protected int port;

        public AbstractRemoteConnection(Node node) {
            super(node);
        }

        public String user() {
            return this.user;
        }

        public String url() {
            return this.url;
        }

        public int port() {
            return this.port;
        }

        public Server.RemoteConnection user(String value) {
            this.user = value;
            return (Server.RemoteConnection)this;
        }

        public Server.RemoteConnection url(String value) {
            this.url = value;
            return (Server.RemoteConnection)this;
        }

        public Server.RemoteConnection port(int value) {
            this.port = value;
            return (Server.RemoteConnection)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = IntegerLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = (String)values.get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public class Clear {
        public void process(Predicate<Process> filter) {
            new ArrayList<Process>(AbstractServer.this.processList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Perceptible.Create {
        public Create(String name) {
            super(name);
        }

        public ServerConsul serverConsul(String version) {
            ServerConsul newElement = AbstractServer.this.core$().graph().concept(ServerConsul.class).createNode(this.name, AbstractServer.this.core$()).as(ServerConsul.class);
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Process process(String label, String identifier, String vcs) {
            Process newElement = AbstractServer.this.core$().graph().concept(Process.class).createNode(this.name, AbstractServer.this.core$()).as(Process.class);
            newElement.core$().set(newElement, "label", Collections.singletonList(label));
            newElement.core$().set(newElement, "identifier", Collections.singletonList(identifier));
            newElement.core$().set(newElement, "vcs", Collections.singletonList(vcs));
            return newElement;
        }

        public Server.RemoteConnection remoteConnection(String user, String url, int port) {
            Server.RemoteConnection newElement = AbstractServer.this.core$().graph().concept(Server.RemoteConnection.class).createNode(this.name, AbstractServer.this.core$()).as(Server.RemoteConnection.class);
            newElement.core$().set(newElement, "user", Collections.singletonList(user));
            newElement.core$().set(newElement, "url", Collections.singletonList(url));
            newElement.core$().set(newElement, "port", Collections.singletonList(port));
            return newElement;
        }

        public Server.Memory memory(double capacity, double frequency) {
            Server.Memory newElement = AbstractServer.this.core$().graph().concept(Server.Memory.class).createNode(this.name, AbstractServer.this.core$()).as(Server.Memory.class);
            newElement.core$().set(newElement, "capacity", Collections.singletonList(capacity));
            newElement.core$().set(newElement, "frequency", Collections.singletonList(frequency));
            return newElement;
        }

        public Server.CPU cPU(int cores, double frequency) {
            Server.CPU newElement = AbstractServer.this.core$().graph().concept(Server.CPU.class).createNode(this.name, AbstractServer.this.core$()).as(Server.CPU.class);
            newElement.core$().set(newElement, "cores", Collections.singletonList(cores));
            newElement.core$().set(newElement, "frequency", Collections.singletonList(frequency));
            return newElement;
        }

        public Server.HDD hDD(double capacity, int frequency) {
            Server.HDD newElement = AbstractServer.this.core$().graph().concept(Server.HDD.class).createNode(this.name, AbstractServer.this.core$()).as(Server.HDD.class);
            newElement.core$().set(newElement, "capacity", Collections.singletonList(capacity));
            newElement.core$().set(newElement, "frequency", Collections.singletonList(frequency));
            return newElement;
        }
    }

    public static enum Scope {
        DEV,
        PRE,
        PRO,
        EXP,
        DEMO;

    }
}

