/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ProcessDeployment
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private int jmxPort = 0;
    private String jvmOptions;
    private String destinationServer;
    private Requirements requirements;
    private Packaging packaging;
    private List<Artifactory> artifactory = new ArrayList<Artifactory>();
    private Vcs vcs;

    public String groupId() {
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public String jvmOptions() {
        return this.jvmOptions;
    }

    public String destinationServer() {
        return this.destinationServer;
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public Packaging packaging() {
        return this.packaging;
    }

    public List<Artifactory> artifactoryList() {
        return this.artifactory;
    }

    public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
        return this.artifactory.stream().filter(predicate).collect(Collectors.toList());
    }

    public Artifactory artifactory(Predicate<Artifactory> predicate) {
        return this.artifactory.stream().filter(predicate).findFirst().orElse(null);
    }

    public Vcs vcs() {
        return this.vcs;
    }

    public ProcessDeployment groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public ProcessDeployment artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public ProcessDeployment version(String version) {
        this.version = version;
        return this;
    }

    public ProcessDeployment jmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
        return this;
    }

    public ProcessDeployment jvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public ProcessDeployment destinationServer(String destinationServer) {
        this.destinationServer = destinationServer;
        return this;
    }

    public ProcessDeployment requirements(Requirements requirements) {
        this.requirements = requirements;
        return this;
    }

    public ProcessDeployment packaging(Packaging packaging) {
        this.packaging = packaging;
        return this;
    }

    public ProcessDeployment artifactoryList(List<Artifactory> artifactory) {
        this.artifactory = artifactory;
        return this;
    }

    public ProcessDeployment vcs(Vcs vcs) {
        this.vcs = vcs;
        return this;
    }

    public static class Vcs
    implements Serializable {
        private String url;
        private String commit;

        public String url() {
            return this.url;
        }

        public String commit() {
            return this.commit;
        }

        public Vcs url(String url) {
            this.url = url;
            return this;
        }

        public Vcs commit(String commit) {
            this.commit = commit;
            return this;
        }
    }

    public static class Artifactory
    implements Serializable {
        private String id;
        private String url;
        private String user;
        private String password;

        public String id() {
            return this.id;
        }

        public String url() {
            return this.url;
        }

        public String user() {
            return this.user;
        }

        public String password() {
            return this.password;
        }

        public Artifactory id(String id) {
            this.id = id;
            return this;
        }

        public Artifactory url(String url) {
            this.url = url;
            return this;
        }

        public Artifactory user(String user) {
            this.user = user;
            return this;
        }

        public Artifactory password(String password) {
            this.password = password;
            return this;
        }
    }

    public static class Packaging
    implements Serializable {
        private String classpathPrefix;
        private String mainClass;
        private List<Parameter> parameter = new ArrayList<Parameter>();

        public String classpathPrefix() {
            return this.classpathPrefix;
        }

        public String mainClass() {
            return this.mainClass;
        }

        public List<Parameter> parameterList() {
            return this.parameter;
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameter.stream().filter(predicate).collect(Collectors.toList());
        }

        public Parameter parameter(Predicate<Parameter> predicate) {
            return this.parameter.stream().filter(predicate).findFirst().orElse(null);
        }

        public Packaging classpathPrefix(String classpathPrefix) {
            this.classpathPrefix = classpathPrefix;
            return this;
        }

        public Packaging mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Packaging parameterList(List<Parameter> parameter) {
            this.parameter = parameter;
            return this;
        }

        public static class Parameter
        implements Serializable {
            private String name;
            private String value;

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public Parameter name(String name) {
                this.name = name;
                return this;
            }

            public Parameter value(String value) {
                this.value = value;
                return this;
            }
        }
    }

    public static class Requirements
    implements Serializable {
        private int minMemory = 0;
        private int maxMemory = 0;
        private double hdd = 2.0;
        private Map<String, List<String>> syncFileToServer = new HashMap<String, List<String>>();

        public int minMemory() {
            return this.minMemory;
        }

        public int maxMemory() {
            return this.maxMemory;
        }

        public double hdd() {
            return this.hdd;
        }

        public Map<String, List<String>> syncFileToServer() {
            return this.syncFileToServer;
        }

        public Requirements minMemory(int minMemory) {
            this.minMemory = minMemory;
            return this;
        }

        public Requirements maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public Requirements hdd(double hdd) {
            this.hdd = hdd;
            return this;
        }

        public Requirements syncFileToServer(Map<String, List<String>> syncFileToServer) {
            this.syncFileToServer = syncFileToServer;
            return this;
        }
    }
}

