/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.rest.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.actions.GetServerLogAction;
import io.intino.cesar.box.schemas.ServerStatus;

public class GetServerLogResource
implements Resource {
    private CesarBox box;
    private SparkManager<SparkPushService> manager;

    public GetServerLogResource(CesarBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws AlexandriaException {
        this.write(this.fill(new GetServerLogAction()).execute());
    }

    private GetServerLogAction fill(GetServerLogAction action) throws AlexandriaException {
        action.box = this.box;
        action.context = this.context();
        try {
            action.server = RequestAdapter.adapt(this.manager.fromPath("server"), String.class);
        }
        catch (Throwable e) {
            action.onMalformedRequest(e);
        }
        return action;
    }

    private void write(ServerStatus object) {
        this.manager.write(ResponseAdapter.adapt(object));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        context.put("Authorization", this.manager.fromHeader("Authorization").replace("Bearer ", ""));
        context.put("ip", this.manager.ip());
        return context;
    }
}

