/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.rest.notifications;

import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.MessageCarrier;
import io.intino.alexandria.http.pushservice.Session;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkNotifier;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.http.spark.SparkSession;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.actions.LogAction;
import java.util.UUID;

public class LogNotification
implements Resource {
    private CesarBox box;
    private SparkManager<SparkPushService> manager;

    public LogNotification(CesarBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws Unauthorized {
        SparkSession session = this.manager.currentSession();
        String clientId = UUID.randomUUID().toString();
        LogAction action = this.fill(new LogAction());
        this.manager.pushService().onOpen(client -> {
            action.onOpen((Client)client, this.notifier(session, (Client)client));
            return true;
        });
        this.manager.pushService().onClose(clientId).execute(action::onClose);
        this.write(this.manager.baseUrl().replace("http", "ws") + "/push?id=" + clientId);
    }

    private LogAction fill(LogAction action) {
        action.box = this.box;
        action.context = this.context();
        action.process = RequestAdapter.adapt(this.manager.fromQuery("process"), String.class);
        return action;
    }

    private void write(String object) {
        this.manager.write(ResponseAdapter.adapt(object), "text/plain");
    }

    private SparkNotifier notifier(Session session, Client client) {
        return new SparkNotifier(new MessageCarrier(this.manager.pushService(), session, client));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        context.put("ip", this.manager.ip());
        return context;
    }
}

