/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageBuilder;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.ProcessEventConsumer;
import io.intino.cesar.box.mounters.Mounter;
import io.intino.cesar.box.schemas.Log;
import io.intino.cesar.checkers.ProcessChecker;
import io.intino.cesar.checkers.ProcessLogChecker;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.graph.Process;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProcessMounter
implements Mounter {
    private final CesarBox box;

    public ProcessMounter(CesarBox box) {
        this.box = box;
    }

    public void handle(ProcessStatus status) {
        if (status == null) {
            Logger.error("status null");
            return;
        }
        Process process = this.box.graph().process(status.serverId(), status.id());
        if (process == null || process.currentStatus() != null && process.currentStatus().ts().isAfter(status.ts())) {
            return;
        }
        process.started(status.running()).debugPort(status.debugPort()).debugging(status.debugPort() != 0).save$();
        process.add(status);
        new ProcessChecker(process, this.box).check();
    }

    public void handle(ProcessLog processLog) {
        if (processLog == null) {
            return;
        }
        Process process = this.box.graph().process(processLog.serverId(), processLog.id());
        if (process == null) {
            return;
        }
        List<Message> messages = this.hasAlexandriaFormat(processLog.value()) ? this.processAlexandriaLog(process, processLog) : this.buildMessage(processLog.value());
        this.notifyListeners(process, messages);
        this.processNotifications(process, messages.stream().filter(m -> m.type().equalsIgnoreCase(Logger.Level.NOTIFICATION.name())).collect(Collectors.toList()));
        this.saveLog(processLog, process, messages);
        new ProcessLogChecker(this.box, process).check(messages);
    }

    private void processNotifications(Process process, List<Message> messages) {
        EventNotifier eventNotifier = new EventNotifier(this.box);
        for (Message message : messages) {
            eventNotifier.notify(process.responsibles(), "Process " + process.label() + " on " + process.deployedServer().label(), message.contains("message") ? message.get("message").asString() : messages.toString());
        }
    }

    private void saveLog(ProcessLog processLog, Process process, List<Message> messages) {
        if (!process.currentLog().exists()) {
            this.createLogFile(processLog, process, messages);
        } else {
            this.appendLog(processLog, process, messages);
        }
    }

    private void notifyListeners(Process process, List<Message> messages) {
        List<ProcessEventConsumer> logSubscribers = this.box.logSubscribers(process.name$());
        if (logSubscribers != null) {
            logSubscribers.forEach(s -> s.accept(process.name$() + "#" + process.identifier() + "#" + messages.stream().map(Message::toString).collect(Collectors.joining("\n"))));
        }
    }

    private List<Message> buildMessage(String value) {
        Message message = MessageBuilder.toMessage(new LogMessage().ts(Instant.now()).message(value));
        message.type(value.contains("Exception") || value.contains("exception") ? "ERROR" : "INFO");
        return Collections.singletonList(message);
    }

    private void createLogFile(ProcessLog processLog, Process process, List<Message> messages) {
        File file = process.currentLog();
        try {
            Files.write(file.toPath(), messages.isEmpty() ? (processLog.value() + "\n").getBytes() : this.bytesOf(messages), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<Message> processAlexandriaLog(Process process, ProcessLog processLog) {
        List<Message> messages = this.loadLogMessage(process, processLog).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (messages.isEmpty()) {
            return messages;
        }
        messages.forEach(m -> m.type(m.type().trim()));
        messages.forEach(m -> m.set("ts", m.get("ts").asString().replace("+0000", "Z")));
        return messages;
    }

    private List<Message> loadLogMessage(Process process, ProcessLog processLog) {
        return processLog.value().startsWith("Process exited with code:") && !process.isStopped() ? Collections.singletonList(MessageBuilder.toMessage(new Log().level("error").message(processLog.value()).ts(processLog.ts()))) : this.messages(processLog);
    }

    private List<Message> messages(ProcessLog processLog) {
        try {
            return MessageManager.readMessages(processLog.value().replace(": \n", ":\n"));
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    private void appendLog(ProcessLog processLog, Process process, List<Message> messages) {
        try {
            File logFile = process.currentLog();
            Files.write(logFile.toPath(), messages.isEmpty() ? (processLog.value() + "\n").getBytes() : this.bytesOf(messages), StandardOpenOption.APPEND);
            long size = logFile.length() / 0x100000L;
            if (size >= 25L) {
                this.truncate(logFile);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void truncate(File file) {
        try {
            String messages = new String(Files.readAllBytes(file.toPath()));
            Files.write(file.toPath(), messages.substring(messages.length() / 2).getBytes(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private byte[] bytesOf(List<Message> messages) {
        return messages.stream().map(m -> m + "\n").collect(Collectors.joining()).getBytes();
    }

    private boolean hasAlexandriaFormat(String value) {
        if (value.contains("\n")) {
            String signature = value.substring(0, value.indexOf("\n"));
            return signature.matches("\\[.*]") && this.isLogSignature(signature.substring(1, signature.length() - 1));
        }
        return false;
    }

    private boolean isLogSignature(String type) {
        if (type == null) {
            return false;
        }
        return !StringUtils.isNumeric(type.substring(1));
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessStatus) {
            this.handle((ProcessStatus)event);
        }
        if (event instanceof ProcessLog) {
            this.handle((ProcessLog)event);
        }
    }

    public static class LogMessage {
        Instant ts;
        String source;
        String message;

        public LogMessage ts(Instant ts) {
            this.ts = ts;
            return this;
        }

        public LogMessage source(String source) {
            this.source = source;
            return this;
        }

        public LogMessage message(String message) {
            this.message = message;
            return this;
        }
    }
}

