/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RestBot {
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final Map<String, CommandInfo> commandsInfo = new LinkedHashMap<String, CommandInfo>();
    protected Map<String, Context> usersContext = new LinkedHashMap<String, Context>();

    protected String help() {
        StringBuilder help = new StringBuilder("commands:\n");
        for (String key : this.commandsInfo.keySet()) {
            help.append(key).append(this.parameters(this.commandsInfo.get((Object)key).parameters)).append(": ").append(this.commandsInfo.get((Object)key).description).append("\n");
        }
        return help.toString();
    }

    public Map<String, CommandInfo> commandsInfo() {
        return this.commandsInfo;
    }

    public Map<String, CommandInfo> commandsInfoByContext(String context) {
        return this.commandsInfo.keySet().stream().filter(command -> this.commandsInfo.get((Object)command).context.equalsIgnoreCase(context)).collect(Collectors.toMap(command -> command, this.commandsInfo::get, (a, b) -> b, LinkedHashMap::new));
    }

    public Map<String, Context> contexts() {
        return this.usersContext;
    }

    public Object talk(String userName, String message, MessageProperties properties) {
        String[] content = (String[])Arrays.stream(message.split(" ")).filter(s -> !s.trim().isEmpty()).map(this::decode).toArray(String[]::new);
        CommandInfo commandInfo = this.commandsInfo.get((String)(this.contexts().get((Object)userName).command.isEmpty() || this.isBundledCommand(content[0].toLowerCase()) ? "" : this.contexts().get((Object)userName).command + "$") + content[0].toLowerCase());
        String context = commandInfo != null ? commandInfo.context : "";
        String commandKey = (String)(context.isEmpty() ? "" : context + "$") + content[0].toLowerCase();
        Command command = this.commandNotFound();
        if (commandInfo != null && this.commands.containsKey(commandKey) && this.isInContext(commandKey, userName)) {
            command = this.commands.get(commandKey);
        } else if (this.commands.containsKey(commandKey) && Objects.equals(context, "")) {
            command = this.commands.get(commandKey);
        }
        return command.execute(properties, content.length > 1 ? Arrays.copyOfRange(content, 1, content.length) : new String[]{});
    }

    protected void add(String name, List<String> parameters, List<String> components, String description, Command command) {
        this.commands.put(name, command);
        this.commandsInfo.put(name, new CommandInfo(parameters, "", components, description));
    }

    protected void add(String name, String context, List<String> parameters, List<String> components, String description, Command command) {
        this.commands.put((String)(context.isEmpty() ? "" : context + "$") + name, command);
        this.commandsInfo.put((String)(context.isEmpty() ? "" : context + "$") + name, new CommandInfo(parameters, context, components, description));
    }

    private String parameters(List<String> parameters) {
        return parameters.isEmpty() ? "" : " `" + String.join((CharSequence)"` `", parameters) + "`";
    }

    private String decode(String message) {
        if (message.startsWith("<") && message.endsWith(">")) {
            if (message.contains("|")) {
                return message.substring(message.indexOf("|1"), message.length() - 1);
            }
            return message.substring(1, message.length() - 1);
        }
        return message;
    }

    private Command commandNotFound() {
        return (messageProperties, args) -> "Command not found";
    }

    private boolean isInContext(String commandKey, String userName) {
        Context context = this.usersContext.get(userName);
        return this.isBundledCommand(commandKey) || context != null && (context.command.isEmpty() || context.command.equalsIgnoreCase(commandKey.substring(0, commandKey.lastIndexOf("$"))));
    }

    private boolean isBundledCommand(String commandKey) {
        return commandKey.equalsIgnoreCase("help") || commandKey.equalsIgnoreCase("where") || commandKey.equalsIgnoreCase("exit");
    }

    public void createContextFor(String name) {
        this.usersContext.put(name, new Context("", new String[0]));
    }

    public static class CommandInfo {
        private final List<String> parameters;
        private final String description;
        private final String context;
        private final List<String> components;

        CommandInfo(List<String> parameters, String context, List<String> components, String description) {
            this.parameters = parameters;
            this.context = context;
            this.components = components;
            this.description = description;
        }

        public List<String> parameters() {
            return this.parameters;
        }

        public List<String> components() {
            return this.components;
        }

        public String description() {
            return this.description;
        }
    }

    public static class Attachment {
        private final InputStream inputStream;
        private final String title;
        private final String fileName;
        private final Type type;

        public Type getType() {
            return this.type;
        }

        public Attachment(InputStream inputStream, String title, String fileName, Type type) {
            this.inputStream = inputStream;
            this.title = title;
            this.fileName = fileName;
            this.type = type;
        }

        public Attachment(byte[] bytes, String title, String fileName, Type type) {
            this(new ByteArrayInputStream(bytes), title, fileName, type);
        }

        public String getTitle() {
            return this.title;
        }

        public String getFileName() {
            return this.fileName;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public static enum Type {
            File,
            Image;

        }
    }

    public static class Context {
        private String command;
        private String[] objects;

        public Context(String command, String ... objects) {
            this.command = command;
            this.objects = objects;
        }

        public String command() {
            return this.command;
        }

        public void command(String command) {
            this.command = command;
        }

        public String[] getObjects() {
            return this.objects;
        }

        public void objects(String ... objects) {
            this.objects = objects;
        }
    }

    public static interface MessageProperties {
        public String channel();

        public String username();

        public String ts();

        public String timeZone();

        public Context context();

        public Attachment attachment();
    }

    public static interface Command {
        public Object execute(MessageProperties var1, String ... var2);
    }
}

