/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.bot.ChatSection;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.bot.helpers.BotMessageFormatter;
import io.intino.cesar.box.bot.helpers.ImageHelper;
import io.intino.cesar.box.schemas.DeviceStatus;
import io.intino.cesar.checkers.ScreenDownloader;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.User;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceContext
extends ChatSection {
    public DeviceContext(CesarBox box) {
        super(box);
    }

    public String info(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        return "*" + device.label() + "*\n- android version: " + device.androidVersion() + "\n- consul version: " + device.consul().version();
    }

    public String status(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String response = this.box.deviceAccessor(device).status();
        if (DeviceContext.valid(response)) {
            DeviceStatus status = MessageManager.fromMessage(response, DeviceStatus.class);
            return device.label() + "> " + BotMessageFormatter.format(status, properties.timeZone());
        }
        return device.label() + "> " + response;
    }

    public String reboot(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).reboot();
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String responsibles(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (User responsible : device.responsibles()) {
            builder.append(responsible.name$());
            builder.append(" ").append(responsible.mail()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String setResponsibles(RestBot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        List responsibles = this.graph().userList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("setresponsibles", properties.username(), device, users));
        return ":ok_hand:";
    }

    public String setNotifications(RestBot.MessageProperties properties, String unplug, String temperature, String battery, String lowBattery, String disconnected) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("setnotifications", properties.username(), device, "" + DeviceContext.state(unplug), "" + DeviceContext.state(temperature), "" + DeviceContext.state(battery), "" + DeviceContext.state(lowBattery), "" + DeviceContext.state(disconnected)));
        return "Notifications are now: \n\tunplug:" + unplug + "\n\ttemperature:" + temperature + "\n\tbattery:" + battery + "\n\tlowBattery:" + lowBattery + "\n\tdisconnected:" + disconnected + "\n";
    }

    public Object screen(RestBot.MessageProperties properties, String state) {
        Device device = this.findDevice(properties);
        if (state.isEmpty()) {
            return this.captureScreen(properties);
        }
        if (device == null) {
            return "No device has been connected";
        }
        String screenon = DeviceContext.state(state) ? this.box.deviceAccessor(device).screenOn() : this.box.deviceAccessor(device).screenOff();
        return device.label() + "> " + (DeviceContext.valid(screenon) ? ":ok_hand:" : screenon);
    }

    public Object grid(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        byte[] capturedScreen = new ScreenDownloader(this.box).screenOf(device);
        if (capturedScreen != null) {
            return new RestBot.Attachment(ImageHelper.decodeWithGrid(capturedScreen, device), "Capture.jpg", device.label() + "> Capture.jpg", RestBot.Attachment.Type.Image);
        }
        return device.label() + "> Error capturing screen";
    }

    private Object captureScreen(RestBot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        byte[] capturedScreen = new ScreenDownloader(this.box).screenOf(device);
        if (capturedScreen != null) {
            BufferedImage image = ImageHelper.withTimeMark(device.screen(), capturedScreen);
            if (image != null) {
                device.screen().save(ImageHelper.decodeImage(image));
            }
            return new RestBot.Attachment(capturedScreen, "Capture.jpg", device.label() + "> Capture.jpg", RestBot.Attachment.Type.Image);
        }
        return device.label() + "> Error capturing screen";
    }

    public String tap(RestBot.MessageProperties properties, String square) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        return this.tapPixel(properties, ImageHelper.pixelXOf(square, device), ImageHelper.pixelYOf(square, device));
    }

    public String tapPixel(RestBot.MessageProperties properties, int x, int y) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).tap(x, y);
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String drag(RestBot.MessageProperties properties, String from, String to) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).drag(ImageHelper.pixelXOf(from, device), ImageHelper.pixelYOf(from, device), ImageHelper.pixelXOf(from, device), ImageHelper.pixelYOf(to, device));
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String kill(RestBot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).killTask(packageName);
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String launch(RestBot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).launchTask(packageName);
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String uninstall(RestBot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).deleteAPP(packageName);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String install(RestBot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).installAPP(url.replaceAll("[<>]", ""));
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String name(RestBot.MessageProperties properties, String newName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("rename", properties.username(), device, newName));
        properties.context().objects(newName);
        return ":ok_hand:";
    }

    public String update(RestBot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).updateAPP(url.replaceAll("[<>]", ""));
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    public String execute(RestBot.MessageProperties properties, String[] args) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = this.box.deviceAccessor(device).execute(args);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (DeviceContext.valid(result) ? ":ok_hand:" : result);
    }

    private Device findDevice(RestBot.MessageProperties properties) {
        RestBot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Device device = this.graph().searchDeviceByName(context.getObjects()[0]);
        return device == null ? this.graph().searchDeviceByPosition(context.getObjects()[0]) : device;
    }

    private static boolean valid(String result) {
        return !result.startsWith("Error");
    }

    private static boolean state(String alert) {
        return alert.equals("on");
    }
}

