/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.schemas.ServerInfo;
import io.intino.cesar.graph.Server;

public class GetServerAction {
    public CesarBox box;
    public String server;
    public Context context;

    public ServerInfo execute() throws BadRequest {
        return this.toSchema(this.server());
    }

    private ServerInfo toSchema(Server server) {
        ServerInfo schema = new ServerInfo().id(server.name$()).active(!server.isDisconnected()).architecture(server.architecture()).os(server.os()).jvm(server.jvm()).ip(server.ip());
        if (server.cPU() != null) {
            schema.cores(server.cPU().cores());
        }
        if (server.memory() != null) {
            schema.memorySize(server.memory().capacity());
        }
        if (server.hDD() != null) {
            schema.diskSize((long)server.hDD().capacity());
        }
        if (server.remoteConnection() != null) {
            schema.remoteConnection(new ServerInfo.RemoteConnection().url(server.remoteConnection().url()).port(server.remoteConnection().port()).user(server.remoteConnection().user()));
        }
        return schema;
    }

    private Server server() throws BadRequest {
        return (Server)this.box.graph().assetList().stream().filter(a -> a instanceof Server && a.name$().equals(this.server)).findFirst().orElseThrow(() -> new BadRequest("Server not found"));
    }

    public void onMalformedRequest(Throwable e) throws BadRequest {
        throw new BadRequest("Malformed request");
    }
}

