/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.accessors;

import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cesar.datahub.events.OperationResult;
import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.consul.ConsulJmsAccessor;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;

public class ServerProcessAccessor {
    private final JmsConnector connector;
    private final Process process;

    public ServerProcessAccessor(JmsConnector connector, Process process) {
        this.connector = connector;
        this.process = process;
    }

    public ProcessLog log() {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.processLog(this.process.identifier(), log -> {
                result[0] = log;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0] == null ? null : (ProcessLog)result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return (ProcessLog)result[0];
        }
    }

    public ProcessStatus status() {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.processStatus(this.process.identifier(), status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0] == null ? null : (ProcessStatus)result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return (ProcessStatus)result[0];
        }
    }

    public OperationResult operation(Operations.Operation operation) {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.processOperation(operation, value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(120000L);
            consumer.close();
            return result[0] == null ? null : (OperationResult)result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return (OperationResult)result[0];
        }
    }

    private ConsulJmsAccessor accessor() {
        if (this.process.consul() == null) {
            return null;
        }
        return new ConsulJmsAccessor(this.connector.session(), this.process.consul().core$().ownerAs(Server.class).name$());
    }

    public Boolean start() {
        Boolean[] result = new Boolean[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.startProcess(this.process.identifier(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    public Boolean stop() {
        Boolean[] result = new Boolean[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.stopProcess(this.process.identifier(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    public Boolean restart() {
        Boolean[] result = new Boolean[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.restartProcess(this.process.identifier(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    public Boolean debug() {
        Boolean[] result = new Boolean[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.debugProcess(this.process.identifier(), this.process.debugPort(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    public Boolean retract() {
        Boolean[] result = new Boolean[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.retract(this.process.identifier(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    public List<Operations.Operation> operations() {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJmsAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.processOperations(this.process.identifier(), value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0] == null ? null : (List)result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return (List)result[0];
        }
    }

    public Boolean parameter(Process process, String name, String value) {
        ConsulJmsAccessor accessor;
        Thread thread = Thread.currentThread();
        Boolean[] result = new Boolean[]{false};
        List<Process.Deployment.Parameter> parameters = process.deployment(process.deploymentList().size() - 1).parameterList();
        Process.Deployment.Parameter parameter = parameters.stream().filter(p -> p.name$().equals(name)).findFirst().orElse(null);
        if (parameter != null) {
            parameter.value(value);
        }
        if ((accessor = this.accessor()) == null) {
            return null;
        }
        MessageConsumer consumer = null;
        try {
            consumer = accessor.parameter(process.identifier(), name, value, success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(20000L);
            consumer.close();
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }
}

