/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.accessors;

import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.cesar.graph.Server;
import io.intino.consul.ConsulJmsAccessor;
import javax.jms.JMSException;

public class ConsulServerAccessor {
    private final ConsulJmsAccessor jmsAccessor;

    public ConsulServerAccessor(JmsConnector connector, Server server) {
        this.jmsAccessor = new ConsulJmsAccessor(connector.session(), server.serverConsul().core$().ownerAs(Server.class).name$());
    }

    public ServerStatus status() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            this.jmsAccessor.status(status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(10000L);
            return (ServerStatus)result[0];
        }
        catch (InterruptedException | JMSException e) {
            return (ServerStatus)result[0];
        }
    }

    public boolean reboot() {
        Boolean[] result = new Boolean[]{false};
        try {
            Thread thread = Thread.currentThread();
            this.jmsAccessor.reboot(status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(10000L);
            return result[0];
        }
        catch (JMSException e) {
            return false;
        }
        catch (InterruptedException e) {
            return result[0];
        }
    }

    public DeployResult deploy(Deploy schema) {
        DeployResult[] result = new DeployResult[]{new DeployResult().success(false).remarks("No response")};
        try {
            Thread thread = Thread.currentThread();
            this.jmsAccessor.deploy(schema, v -> {
                result[0] = v;
                thread.interrupt();
            });
            Thread.sleep(600000L);
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            return result[0];
        }
    }

    public boolean upgrade() {
        Boolean[] result = new Boolean[]{false};
        try {
            Thread thread = Thread.currentThread();
            this.jmsAccessor.upgrade(finish -> {
                result[0] = finish;
                thread.interrupt();
            });
            Thread.sleep(300000L);
            return result[0] != null && result[0] != false;
        }
        catch (InterruptedException | JMSException e) {
            return result[0];
        }
    }
}

