/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.LDAPUserService;
import io.intino.cesar.box.UserService;
import io.intino.cesar.box.infrastructure.mounters.ProcessMounter;
import io.intino.cesar.box.infrastructure.mounters.ServerMounter;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.User;
import io.intino.magritte.framework.stores.FileSystemStore;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class DatamartGenerator {
    private final CesarBox box;
    private final CesarGraph graph;
    private Base64.Encoder encoder;

    public DatamartGenerator(CesarBox box) {
        this.box = box;
        this.encoder = Base64.getEncoder();
        this.graph = box.graph();
    }

    public void generate() {
        Instant initTime = Instant.now();
        Logger.info("Igniting datamart");
        this.loadGraph(this.box.configuration.home());
        this.loadUsers();
        this.reflowServerStatus();
        Logger.info("Datamart created in " + DatamartGenerator.format(Duration.between(initTime, Instant.now())) + "!");
    }

    private void loadUsers() {
        new LDAPUserService(this.box.configuration.ldapUrl(), this.box.configuration.ldapDomain(), this.box.configuration.ldapUser(), this.box.configuration.ldapPassword()).users().forEach(this::addUser);
    }

    private void addUser(UserService.User user) {
        String name = user.name();
        if (this.graph.userList().stream().anyMatch(r -> r.name$().equals(name))) {
            this.update(this.graph.userList().stream().filter(r -> r.name$().equals(name)).findFirst().get(), user);
        } else {
            this.graph.create("Users", name).user(user.fullName(), user.mail(), this.encoder.encodeToString((user.name() + ":" + user.password()).getBytes())).save$();
        }
        this.box.cesarBot().createContextFor(name);
    }

    private void update(User existent, UserService.User user) {
        existent.mail(user.mail()).fullName(user.fullName()).token(this.encoder.encodeToString((user.name() + ":" + user.password()).getBytes())).save$();
    }

    private void loadGraph(File home) {
        String path;
        Path relativize;
        File infrastructureDir;
        if (this.graph.configuration() == null) {
            this.graph.create("Configuration").configuration().core$().save();
        }
        List<File> infrastructure = (infrastructureDir = new File(home, "infrastructure")).exists() ? FileUtils.listFiles(infrastructureDir, new String[]{"stash"}, true) : Collections.emptyList();
        File statusDir = new File(home, "status");
        List<File> status = statusDir.exists() ? FileUtils.listFiles(statusDir, new String[]{"stash"}, true) : Collections.emptyList();
        for (File file : infrastructure) {
            relativize = home.toPath().relativize(file.toPath());
            path = relativize.toFile().getPath();
            this.graph.core$().loadStashes(path);
        }
        for (File file : status) {
            relativize = home.toPath().relativize(file.toPath());
            path = relativize.toFile().getPath();
            this.graph.core$().loadStashes(path);
        }
    }

    private void reflowServerStatus() {
        ((FileSystemStore)this.box.graph().core$().store()).allowWriting(false);
        Logger.trace("Reflowing boot and status");
        Instant lastHour = Instant.now().minusSeconds(3600L);
        ServerMounter serverMounter = new ServerMounter(this.box);
        ProcessMounter processMounter = new ProcessMounter(this.box);
        AtomicInteger reflowed = new AtomicInteger(0);
        this.reflowLast("consul.server.ServerBoot", m -> this.mount(serverMounter, (Message)m, reflowed));
        Logger.trace("Reflowed " + reflowed.get() + " ServerBoot");
        reflowed.set(0);
        this.reflowLast("consul.server.ServerStatus", m -> this.mount(serverMounter, (Message)m, lastHour, reflowed));
        Logger.trace("Reflowed " + reflowed.get() + " ServerStatus");
        reflowed.set(0);
        this.reflowLast("consul.process.ProcessStatus", m -> this.mount(processMounter, (Message)m, lastHour, reflowed));
        Logger.trace("Reflowed " + reflowed.get() + " ProcessStatus");
        Logger.trace("Boot and status reflowed");
    }

    private void reflowLast(String tank, Consumer<Message> handler) {
        List collect = this.box.datalake().eventStore().tank(tank).tubs().sorted(Comparator.comparing(t -> t.timetag().value())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        ((Datalake.EventStore.Tub)collect.get(collect.size() - 1)).events().forEachRemaining(e -> handler.accept(e.toMessage()));
    }

    private void mount(ServerMounter mounter, Message m, Instant lastHour, AtomicInteger reflowed) {
        ServerStatus status = new ServerStatus(m);
        if (status.ts().isAfter(lastHour)) {
            mounter.handle(status);
            reflowed.incrementAndGet();
        }
    }

    private void mount(ServerMounter mounter, Message m, AtomicInteger reflowed) {
        mounter.handle(new ServerBoot(m));
        reflowed.incrementAndGet();
    }

    private void mount(ProcessMounter mounter, Message m, Instant lastHour, AtomicInteger reflowed) {
        ProcessStatus status = new ProcessStatus(m);
        if (status.ts().isAfter(lastHour)) {
            mounter.handle(status);
            reflowed.incrementAndGet();
        }
    }

    private static String format(Duration duration) {
        long absSeconds = Math.abs(duration.getSeconds());
        String positive = String.format("%d:%02d:%02d", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return duration.getSeconds() < 0L ? "-" + positive : positive;
    }
}

