/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cesar.Channels;
import io.intino.cesar.IssueDispatcher;
import io.intino.cesar.box.AbstractBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.DatamartGenerator;
import io.intino.cesar.box.NotificationConsumer;
import io.intino.cesar.box.ProcessEventConsumer;
import io.intino.cesar.box.RocketChat;
import io.intino.cesar.box.accessors.ConsulServerAccessor;
import io.intino.cesar.box.accessors.DeviceAccessor;
import io.intino.cesar.box.accessors.ServerProcessAccessor;
import io.intino.cesar.box.actions.ScheduleSaveGraphAction;
import io.intino.cesar.box.bot.CesarBot;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.CesarStore;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.magritte.framework.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;

public class CesarBox
extends AbstractBox {
    private final Map<String, List<ProcessEventConsumer>> processSubscribers;
    private final Map<String, NotificationConsumer> notificationSubscribers;
    private final IssueDispatcher issueDispatcher;
    private final CesarBot bot;
    private final RocketChat chat;
    private CesarGraph graph;
    private String slackLastCommandUser;
    private ChangeCommitter committer;
    private FileDatalake datalake;

    public CesarBox(CesarConfiguration configuration) {
        super(configuration);
        io.intino.alexandria.logger4j.Logger.setLevel(Level.ERROR);
        this.processSubscribers = new HashMap<String, List<ProcessEventConsumer>>();
        this.notificationSubscribers = new HashMap<String, NotificationConsumer>();
        this.issueDispatcher = new IssueDispatcher(this);
        this.bot = new CesarBot(this);
        this.chat = new RocketChat(configuration.rocketchatUrl(), configuration.rocketchatUser(), configuration.rocketchatPassword());
        AlexandriaSparkBuilder.setUI(false);
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    public Datalake datalake() {
        return this.datalake;
    }

    @Override
    public void beforeStart() {
        File home = this.configuration.home();
        this.datalake = new FileDatalake(new File(home, "datalake"));
        this.graph = new Graph(new CesarStore(home).allowWriting(false)).loadStashes("Cesar", "Configuration", "Users").as(CesarGraph.class);
        new DatamartGenerator(this).generate();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
        ScheduleSaveGraphAction action = new ScheduleSaveGraphAction();
        action.box = this;
        action.execute();
    }

    public ConsulServerAccessor serverAccessor(Server server) {
        return new ConsulServerAccessor((JmsConnector)this.datahubConnector(), server);
    }

    public DeviceAccessor deviceAccessor(Device device) {
        return new DeviceAccessor(this.datahubConnector(), device);
    }

    public ServerProcessAccessor serverProcessAccessor(Process process) {
        return new ServerProcessAccessor((JmsConnector)this.datahubConnector(), process);
    }

    public ChangeCommitter committer() {
        return this.committer == null ? (this.committer = new ChangeCommitter(this.datahubConnector())) : this.committer;
    }

    public void attachLogSubscriber(String processId, ProcessEventConsumer consumer) {
        if (!this.processSubscribers.containsKey(processId)) {
            this.processSubscribers.put(processId, new ArrayList());
        }
        List<ProcessEventConsumer> consumers = this.processSubscribers.get(processId);
        consumers.removeIf(c -> c.user().equals(consumer.user()));
        consumers.add(consumer);
    }

    public List<ProcessEventConsumer> logSubscribers(String processId) {
        return this.processSubscribers.get(processId);
    }

    public NotificationConsumer notificationSubscribers(String user) {
        return this.notificationSubscribers.getOrDefault(user, null);
    }

    public void detachLogConsumer(String processId, String user) {
        this.processSubscribers.get(processId).stream().filter(c -> c.user().equals(user)).findFirst().ifPresent(consumer -> this.processSubscribers.get(processId).remove(consumer));
    }

    public IssueDispatcher issueDispatcher() {
        return this.issueDispatcher;
    }

    public CesarGraph graph() {
        return this.graph;
    }

    public void slackLastActionUser(String username) {
        this.slackLastCommandUser = username;
    }

    public void attachIntellijNotificationSubscriber(String user, NotificationConsumer consumer) {
        this.notificationSubscribers.put(user, consumer);
    }

    public void detachNotificationConsumer(String user) {
        this.notificationSubscribers.remove(user);
    }

    public RestBot cesarBot() {
        return this.bot;
    }

    public RocketChat chat() {
        return this.chat;
    }

    public static class ChangeCommitter {
        private final Connector connector;
        private final Map<String, String> channels = new HashMap<String, String>();

        ChangeCommitter(Connector connector) {
            this.connector = connector;
            this.channels.put("infrastructureoperation", Channels.infrastructureOperation);
            this.channels.put("processoperation", Channels.infrastructureOperation);
            this.channels.put("serverstatus", Channels.serverStatus);
            this.channels.put("serverlog", Channels.serverLog);
            this.channels.put("serverboot", Channels.serverBoot);
            this.channels.put("serverinfo", Channels.serverInfo);
            this.channels.put("devicestatus", Channels.deviceStatus);
            this.channels.put("deviceboot", Channels.deviceBoot);
            this.channels.put("deviceupgrade", Channels.deviceUpgrade);
            this.channels.put("devicecrash", Channels.deviceCrash);
            this.channels.put("processlog", Channels.processLog);
            this.channels.put("processstatus", Channels.processStatus);
        }

        public void commit(Event event) {
            String type = event.getClass().getSimpleName().toLowerCase();
            if (this.channels.get(type) == null) {
                Logger.error("Tank not found " + type);
            } else {
                this.connector.sendEvent(this.channels.get(type), event);
            }
        }
    }
}

