/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.http.spark.SparkRouter;
import io.intino.cesar.box.ApiServiceAuthenticator;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.rest.notifications.BotNotificationsNotification;
import io.intino.cesar.box.rest.notifications.LogNotification;
import io.intino.cesar.box.rest.resources.GetDeviceResource;
import io.intino.cesar.box.rest.resources.GetDeviceStatusResource;
import io.intino.cesar.box.rest.resources.GetDevicesResource;
import io.intino.cesar.box.rest.resources.GetProcessLogResource;
import io.intino.cesar.box.rest.resources.GetProcessResource;
import io.intino.cesar.box.rest.resources.GetProcessStatusResource;
import io.intino.cesar.box.rest.resources.GetProcessesResource;
import io.intino.cesar.box.rest.resources.GetServerLogResource;
import io.intino.cesar.box.rest.resources.GetServerResource;
import io.intino.cesar.box.rest.resources.GetServerStatusResource;
import io.intino.cesar.box.rest.resources.GetServersResource;
import io.intino.cesar.box.rest.resources.PostBotResource;
import io.intino.cesar.box.rest.resources.PostDeployProcessResource;
import io.intino.cesar.box.rest.resources.PostProcessStatusResource;

public class ApiService {
    private static ApiServiceAuthenticator authenticator;

    public static AlexandriaSpark setup(AlexandriaSpark server, CesarBox box) {
        authenticator = new ApiServiceAuthenticator(box);
        if (!AlexandriaSparkBuilder.isUI()) {
            ((SparkRouter)server.route("/push")).push(new SparkPushService());
        }
        ((SparkRouter)server.route("/log")).post(manager -> new LogNotification(box, manager).execute());
        ((SparkRouter)server.route("/bot/notifications")).post(manager -> new BotNotificationsNotification(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/processes")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetProcessesResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/processes/:process")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetProcessResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/processes/:process/status")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetProcessStatusResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/processes/:process/status")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostProcessStatusResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/processes/:process/log")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetProcessLogResource(box, manager).execute());
        ((SparkRouter)server.route("/servers")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetServersResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetServerResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/status")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetServerStatusResource(box, manager).execute());
        ((SparkRouter)server.route("/servers/:server/status")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetServerLogResource(box, manager).execute());
        ((SparkRouter)server.route("/devices")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetDevicesResource(box, manager).execute());
        ((SparkRouter)server.route("/devices/:device")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetDeviceResource(box, manager).execute());
        ((SparkRouter)server.route("/devices/:device/status")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).get(manager -> new GetDeviceStatusResource(box, manager).execute());
        ((SparkRouter)server.route("/deploy")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostDeployProcessResource(box, manager).execute());
        ((SparkRouter)server.route("/bot")).before(manager -> {
            if (!authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostBotResource(box, manager).execute());
        return server;
    }
}

