/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar;

import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;

public class Model {
    private static final int JMX_INITIAL_PORT = 10000;
    private static final int DEBUG_INITIAL_PORT = 6000;

    public static boolean fitsNewProcess(Consul consul, int memory, double hdd) {
        Server server = consul.core$().ownerAs(Server.class);
        List<Process> processes = server.processList();
        int memoryUsed = processes.stream().filter(p -> !p.isStopped()).mapToInt(p -> p.currentDeployment() == null ? 0 : p.currentDeployment().prerequisites().minMemory()).sum();
        double hddUsed = processes.stream().filter(p -> !p.isStopped()).mapToDouble(p -> p.currentDeployment() == null ? 0.0 : p.currentDeployment().prerequisites().hdd()).sum();
        return server.memory().capacity() - (double)memoryUsed >= (double)memory && server.hDD().capacity() - hddUsed > hdd;
    }

    public static boolean fitsProcessChange(ServerConsul consul, Process process, int memory, double hdd) {
        Server server = consul.core$().ownerAs(Server.class);
        List<Process> processes = server.processList();
        int memoryUsed = processes.stream().filter(p -> !p.equals(process) && !p.isStopped()).mapToInt(p -> p.currentDeployment() == null ? 0 : p.currentDeployment().prerequisites().minMemory()).sum();
        double hddUsed = processes.stream().filter(p -> !p.equals(process) && !p.isStopped()).mapToDouble(p -> p.currentDeployment() == null ? 0.0 : p.currentDeployment().prerequisites().hdd()).sum();
        return server.memory().capacity() - (double)memoryUsed >= (double)memory && server.hDD().capacity() - hddUsed > hdd;
    }

    public static boolean isAlive(ServerConsul self) {
        return !self.core$().ownerAs(Server.class).isDisconnected();
    }

    public static int reserveDebugPort(Server self) {
        if (self.debugUsedPorts().isEmpty()) {
            self.debugUsedPorts().add(6000);
            return 6000;
        }
        int newPort = Model.unusedPort(self.debugUsedPorts(), 6000);
        self.debugUsedPorts().add(newPort);
        Collections.sort(self.debugUsedPorts());
        return newPort;
    }

    public static int reserveJMXPort(Server self) {
        if (self.jmxUsedPorts().isEmpty()) {
            self.jmxUsedPorts().add(10000);
            return 10000;
        }
        int newPort = Model.unusedPort(self.jmxUsedPorts(), 10000);
        self.jmxUsedPorts().add(newPort);
        Collections.sort(self.jmxUsedPorts());
        return newPort;
    }

    private static int unusedPort(List<Integer> used, Integer first) {
        int newPort = first;
        while (used.contains(newPort)) {
            ++newPort;
        }
        return newPort;
    }

    public static void releasePort(Server self, int port) {
        if (self.jmxUsedPorts().contains(port)) {
            self.jmxUsedPorts().remove((Object)port);
        }
        if (self.debugUsedPorts().contains(port)) {
            self.debugUsedPorts().remove((Object)port);
        }
    }

    public static void saveScreen(Device.Screen self, byte[] image) {
        self.current(new ByteArrayInputStream(image), "infrastructure/devices/" + self.core$().owner().name() + "/screens/" + Instant.now().atOffset(ZoneOffset.UTC).getHour() + ".jpg");
    }
}

