/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.minlog.Log;
import java.util.concurrent.ConcurrentHashMap;

public class Util {
    public static boolean isAndroid = "Dalvik".equals(System.getProperty("java.vm.name"));
    private static final ConcurrentHashMap<String, Boolean> classAvailabilities = new ConcurrentHashMap();

    public static boolean isClassAvailable(String className) {
        Boolean result = classAvailabilities.get(className);
        if (result == null) {
            try {
                Class.forName(className);
                result = true;
            }
            catch (Exception e) {
                Log.debug("kryo", "Class not available: " + className);
                result = false;
            }
            classAvailabilities.put(className, result);
        }
        return result;
    }

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return Void.class;
    }

    public static Class getPrimitiveClass(Class type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Void.class) {
            return Void.TYPE;
        }
        return type;
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Long.class || type == Byte.class || type == Character.class || type == Short.class || type == Double.class;
    }

    public static void log(String message, Object object) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null");
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object));
        }
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return Log.TRACE ? Util.className(type) : type.getSimpleName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return String.valueOf(object);
        }
        catch (Throwable e) {
            return (Log.TRACE ? Util.className(type) : type.getSimpleName()) + "(Exception " + e + " in toString)";
        }
    }

    public static String className(Class type) {
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static int swapInt(int i) {
        return (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >> 8 | i >> 24 & 0xFF;
    }

    public static long swapLong(long value) {
        return (value >> 0 & 0xFFL) << 56 | (value >> 8 & 0xFFL) << 48 | (value >> 16 & 0xFFL) << 40 | (value >> 24 & 0xFFL) << 32 | (value >> 32 & 0xFFL) << 24 | (value >> 40 & 0xFFL) << 16 | (value >> 48 & 0xFFL) << 8 | (value >> 56 & 0xFFL) << 0;
    }
}

