/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph.rules;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.IssueNotifier;
import io.intino.cesar.countermeasures.device.RecoverApplication;
import io.intino.cesar.countermeasures.device.TurnOffScreen;
import io.intino.cesar.countermeasures.device.TurnOnScreen;
import io.intino.cesar.countermeasures.notifications.MessageProvider;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.Status;
import io.intino.tara.lang.model.Rule;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum Issue implements Rule<Enum>
{
    HighTemperature{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new TurnOffScreen(box).execute((Device)element);
            new IssueNotifier(box).execute(element);
        }

        @Override
        public void resetCounterMeasures(CesarBox box, Identifiable element) {
            new TurnOnScreen(box).execute((Device)element);
        }

        @Override
        protected List<String> historyParameters(Instant ts, Identifiable element) {
            List<String> parameters = super.historyParameters(ts, element);
            parameters.add(element.graph().configuration().deviceTemperatureThreshold() + "");
            return parameters;
        }

        @Override
        protected String[] messageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(Issue.format(((Asset)element.a$(Asset.class)).status().created()));
            parameters.add(element.graph().configuration().deviceBatteryThreshold() + "");
            return parameters.toArray(new String[0]);
        }
    }
    ,
    LowBattery{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }

        @Override
        protected List<String> historyParameters(Instant ts, Identifiable element) {
            List<String> parameters = super.historyParameters(ts, element);
            parameters.add(element.graph().configuration().deviceBatteryThreshold() + "");
            return parameters;
        }

        @Override
        protected String[] messageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(element.graph().configuration().deviceBatteryThreshold() + "");
            return parameters.toArray(new String[0]);
        }

        @Override
        protected String[] longMessageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(Issue.format(((Asset)element.a$(Asset.class)).status().created()));
            parameters.add(element.graph().configuration().deviceLowBatteryThreshold() + "");
            return parameters.toArray(new String[0]);
        }
    }
    ,
    VeryLowBattery{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new TurnOffScreen(box).execute((Device)element);
            new IssueNotifier(box).execute(element);
        }

        @Override
        protected List<String> historyParameters(Instant ts, Identifiable element) {
            List<String> parameters = super.historyParameters(ts, element);
            parameters.add(Issue.format(((Asset)element.a$(Asset.class)).status().created()));
            parameters.add(element.graph().configuration().deviceLowBatteryThreshold() + "");
            return parameters;
        }

        @Override
        protected String[] messageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(element.graph().configuration().deviceBatteryThreshold() + "");
            return parameters.toArray(new String[0]);
        }

        @Override
        protected String[] longMessageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(Issue.format(((Asset)element.a$(Asset.class)).status().created()));
            parameters.add(element.graph().configuration().deviceLowBatteryThreshold() + "");
            return parameters.toArray(new String[0]);
        }
    }
    ,
    Unplugged{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    LogError{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    Misconfigured{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new RecoverApplication(box).execute((Device)element);
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    Stopped{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }

        @Override
        protected List<String> historyParameters(Instant ts, Identifiable element) {
            List<String> parameters = super.historyParameters(ts, element);
            parameters.add(element.graph().configuration().stoppedTimeThreshold() + "");
            return parameters;
        }

        @Override
        protected String[] messageParameters(Identifiable element) {
            return new String[]{element.label(), element.graph().configuration().stoppedTimeThreshold() + ""};
        }

        @Override
        protected String[] longMessageParameters(Identifiable element) {
            return new String[]{Issue.format(((Asset)element.a$(Asset.class)).status().created())};
        }
    }
    ,
    LimitedHardDisk{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    LimitedMemory{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    LimitedCPU{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }
    }
    ,
    Disconnected{

        @Override
        public void execCounterMeasures(CesarBox box, Identifiable element) {
            new IssueNotifier(box).execute(element);
        }

        @Override
        protected List<String> historyParameters(Instant ts, Identifiable element) {
            List<String> parameters = super.historyParameters(ts, element);
            parameters.add(element.graph().configuration().disconnectedTimeThreshold() + "");
            return parameters;
        }

        @Override
        protected String[] messageParameters(Identifiable element) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(element.label());
            parameters.add(element.graph().configuration().disconnectedTimeThreshold() + "");
            return parameters.toArray(new String[0]);
        }

        @Override
        protected String[] longMessageParameters(Identifiable element) {
            Status status = ((Asset)element.core$().as(Asset.class)).status();
            return new String[]{status == null ? "never" : Issue.format(status.created())};
        }
    };


    public abstract void execCounterMeasures(CesarBox var1, Identifiable var2);

    public void resetCounterMeasures(CesarBox box, Identifiable element) {
    }

    public String shortMessage(Identifiable identifiable) {
        return MessageProvider.message(((Object)((Object)identifiable)).getClass().getSimpleName().toLowerCase() + "." + this.name().toLowerCase() + ".subject", this.messageParameters(identifiable));
    }

    public String longMessage(Identifiable identifiable) {
        return MessageProvider.message(((Object)((Object)identifiable)).getClass().getSimpleName().toLowerCase() + "." + this.name().toLowerCase() + ".body", this.longMessageParameters(identifiable));
    }

    protected String[] longMessageParameters(Identifiable identifiable) {
        return this.messageParameters(identifiable);
    }

    protected String[] messageParameters(Identifiable identifiable) {
        return new String[]{identifiable.label()};
    }

    public String historyMessage(Identifiable element, Instant ts, String ... parameters) {
        List<String> params = this.historyParameters(ts, element);
        params.addAll(Arrays.asList(parameters));
        return MessageProvider.message("history." + ((Object)((Object)element)).getClass().getSimpleName().toLowerCase() + "." + this.name().toLowerCase() + ".subject", params.toArray(new String[0]));
    }

    protected List<String> historyParameters(Instant ts, Identifiable element) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.format("date(%s,LLL)", ts.toEpochMilli()));
        params.add(element.label());
        return params;
    }

    private static String format(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault()).format(instant);
    }

    public boolean accept(Enum value) {
        return value instanceof Issue;
    }
}

