/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.sumus.datawarehouse.store.Digest;
import java.time.Instant;

public class SystemDigest {
    private static final String USED_CPU = "cpu";
    private static final String THREADS = "threads";
    private static final String USED_MEMORY = "memory";
    private static final String COUNT = "count";
    private final Digest digest;

    public SystemDigest(Digest digest) {
        this.digest = digest;
    }

    public Instant created() {
        return this.digest.ts().instant();
    }

    public double usedCPU() {
        return this.digest.floatOf(USED_CPU);
    }

    public double usedMemory() {
        return this.digest.floatOf(USED_MEMORY);
    }

    public int threads() {
        return this.digest.intOf(THREADS);
    }

    public SystemDigest addUsedCPU(double value) {
        this.digest.set(USED_CPU, (float)value);
        return this;
    }

    public SystemDigest addUsedMemory(double value) {
        this.digest.set(USED_MEMORY, (float)value);
        return this;
    }

    public SystemDigest addThreads(int value) {
        this.digest.set(THREADS, value);
        return this;
    }

    public SystemDigest addCount() {
        this.digest.add(COUNT, 1);
        return this;
    }

    public SystemDigest save() {
        this.digest.save();
        return this;
    }

    public String ref() {
        return this.digest.ref();
    }
}

