/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Operation;
import io.intino.cesar.graph.SystemStatus;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class System
extends AbstractSystem {
    private SystemStatus status;

    public System(Node node) {
        super(node);
    }

    public SystemStatus status() {
        if (this.statusRef() == null || this.statusRef().isEmpty()) {
            return null;
        }
        Node node = this.graph().core$().clone().load(this.statusRef(), false);
        return node != null ? (SystemStatus)node.as(SystemStatus.class) : null;
    }

    public SystemStatus status(Instant ts) {
        return this.status();
    }

    public System status(SystemStatus status) {
        this.statusRef = status.core$().id();
        this.status = status;
        return this;
    }

    public boolean isRunningOutOfMemory(Instant ts) {
        return false;
    }

    public boolean isRunningOutOfCpu(Instant ts) {
        return false;
    }

    public boolean isStopped() {
        return !this.started() || this.status() == null || this.status() != null && this.status().created().until(Instant.now(), ChronoUnit.HOURS) > (long)this.graph().configuration().stoppedTimeThreshold();
    }

    public AbstractSystem.Deployment currentDeployment() {
        return this.deploymentList().isEmpty() ? null : this.deployment(this.deploymentList().size() - 1);
    }

    public boolean isCompromised() {
        return this.isRunningOutOfCpu(Instant.now()) || this.isRunningOutOfCpu(Instant.now()) || this.isStopped();
    }

    public boolean isCompromised(Instant ts) {
        return this.isRunningOutOfCpu(ts) || this.isRunningOutOfCpu(ts) || this.isStopped();
    }

    public void processNewOperations(List<io.intino.consul.schemas.Operation> newOperations) {
        this.operations().clear().operation(o -> true);
        for (io.intino.consul.schemas.Operation op : newOperations) {
            Operation operation = this.operations().create().operation(this.extractName(op.name()), this.extractParameters(op.name()), op.description());
            operation.returnType(this.extractReturnType(op.name()));
        }
    }

    private List<String> extractParameters(String name) {
        String parameters = name.substring(name.indexOf("(") + 1, name.indexOf(")")).trim();
        return parameters.isEmpty() ? Collections.emptyList() : Arrays.stream(parameters.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private String extractName(String name) {
        String parameters = name.substring(name.indexOf("("), name.indexOf(")") + 1);
        String value = name.replace(parameters, "");
        return value.substring(value.lastIndexOf(" ")).trim();
    }

    private String extractReturnType(String value) {
        return value.substring(0, value.indexOf(" " + this.extractName(value))).trim();
    }
}

