/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.sumus.datawarehouse.store.Digest;
import java.time.Instant;

public class ServerDigest {
    private static final String USED_CPU = "usedCPU";
    private static final String USED_DISK = "usedDisk";
    private static final String INBOUND = "inboundConnections";
    private static final String OUTBOUND = "outboundConnections";
    private static final String USED_MEMORY = "usedMemory";
    private static final String COUNT = "count";
    private final Digest digest;

    public ServerDigest(Digest digest) {
        this.digest = digest;
    }

    public int count() {
        return this.digest.intOf(COUNT);
    }

    public ServerDigest addCount() {
        this.digest.add(COUNT, 1);
        return this;
    }

    public double usedCPU() {
        return this.digest.floatOf(USED_CPU);
    }

    public double usedMemory() {
        return this.digest.floatOf(USED_MEMORY);
    }

    public int inboundConnections() {
        return this.digest.intOf(INBOUND);
    }

    public int outboundConnections() {
        return this.digest.intOf(OUTBOUND);
    }

    public double usedDisk() {
        return this.digest.floatOf(USED_DISK);
    }

    public Instant created() {
        return this.digest.ts().instant();
    }

    public ServerDigest addUsedCPU(double value) {
        this.digest.add(USED_CPU, (float)value);
        return this;
    }

    public ServerDigest addUsedDisk(double value) {
        this.digest.add(USED_DISK, (float)value);
        return this;
    }

    public ServerDigest addUsedMemory(double value) {
        this.digest.add(USED_MEMORY, (float)value);
        return this;
    }

    public ServerDigest addInboundConnections(Integer value) {
        this.digest.add(INBOUND, value.intValue());
        return this;
    }

    public ServerDigest addOutboundConnections(Integer value) {
        this.digest.add(OUTBOUND, value.intValue());
        return this;
    }

    public ServerDigest save() {
        this.digest.save();
        return this;
    }

    public String ref() {
        return this.digest.ref();
    }
}

