/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.ServerStatus;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class Server
extends AbstractServer {
    protected ServerStatus status;

    public Server(Node node) {
        super(node);
    }

    @Override
    public ServerStatus status() {
        if (this.status != null) {
            return this.status;
        }
        if (this.statusRef() == null || this.statusRef().isEmpty()) {
            return null;
        }
        Node node = this.graph().core$().clone().load(this.statusRef(), false);
        return node != null ? (this.status = (ServerStatus)node.as(ServerStatus.class)) : null;
    }

    @Override
    public ServerStatus status(Instant ts) {
        return this.status();
    }

    public Server status(ServerStatus status) {
        this.statusRef = status.core$().id();
        this.status = status;
        return this;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equals("statusRef")) {
            this.status();
        }
    }

    @Override
    public boolean isCompromised() {
        return this.isDisconnected() || this.isRunningOutOfDisk() || this.isRunningOutOfMemory();
    }

    @Override
    public boolean isDisconnected() {
        return this.status == null || this.status() != null && this.status().created().until(Instant.now(), ChronoUnit.HOURS) > (long)this.graph().configuration().disconnectedTimeThreshold();
    }

    @Override
    public boolean isRunningOutOfDisk() {
        return this.status().diskUsage() > 90.0;
    }

    @Override
    public boolean isRunningOutOfMemory() {
        return this.status().memoryUsage() > 90.0;
    }

    @Override
    public boolean isRunningOutOfCpu() {
        return false;
    }

    public boolean isRunningOutOfDisk(Instant ts) {
        ServerStatus status = this.status(ts);
        return status != null && status.diskUsage() > 90.0;
    }

    public boolean isRunningOutOfMemory(Instant ts) {
        return this.status(ts).memoryUsage() > 90.0;
    }

    public boolean isRunningOutOfCpu(Instant ts) {
        return this.status(ts).cpuUsage() == 100.0;
    }

    public boolean isCompromised(Instant ts) {
        return this.isRunningOutOfDisk(ts) || this.isRunningOutOfMemory(ts) || this.isRunningOutOfCpu(ts);
    }
}

