/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class IssueReport
extends Layer
implements Component,
Terminal {
    protected Status status;
    protected Instant ts;
    protected Identifiable target;
    protected Level level;
    protected Issue issue;
    protected int count;
    protected Log log;

    public IssueReport(Node node) {
        super(node);
    }

    public Status status() {
        return this.status;
    }

    public Instant ts() {
        return this.ts;
    }

    public Identifiable target() {
        return this.target;
    }

    public Level level() {
        return this.level;
    }

    public Issue issue() {
        return this.issue;
    }

    public int count() {
        return this.count;
    }

    public IssueReport status(Status value) {
        this.status = value;
        return this;
    }

    public IssueReport ts(Instant value) {
        this.ts = value;
        return this;
    }

    public IssueReport target(Identifiable value) {
        this.target = value;
        return this;
    }

    public IssueReport level(Level value) {
        this.level = value;
        return this;
    }

    public IssueReport issue(Issue value) {
        this.issue = value;
        return this;
    }

    public IssueReport count(int value) {
        this.count = value;
        return this;
    }

    public Log log() {
        return this.log;
    }

    public IssueReport log(Log value) {
        this.log = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.log != null) {
            components.add(this.log.core$());
        }
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("status", new ArrayList<Status>(Collections.singletonList(this.status)));
        map.put("ts", new ArrayList<Instant>(Collections.singletonList(this.ts)));
        map.put("target", this.target != null ? new ArrayList<Identifiable>(Collections.singletonList(this.target)) : Collections.emptyList());
        map.put("level", new ArrayList<Level>(Collections.singletonList(this.level)));
        map.put("issue", new ArrayList<Issue>(Collections.singletonList(this.issue)));
        map.put("count", new ArrayList<Integer>(Collections.singletonList(this.count)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("IssueReport$Log")) {
            this.log = (Log)node.as(Log.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("IssueReport$Log")) {
            this.log = null;
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("status")) {
            this.status = (Status)((Object)WordLoader.load(values, Status.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("ts")) {
            this.ts = (Instant)InstantLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("target")) {
            this.target = (Identifiable)((Object)NodeLoader.load(values, Identifiable.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("level")) {
            this.level = (Level)((Object)WordLoader.load(values, Level.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("issue")) {
            this.issue = (Issue)((Object)WordLoader.load(values, Issue.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("count")) {
            this.count = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("status")) {
            this.status = (Status)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("ts")) {
            this.ts = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("target")) {
            this.target = values.get(0) != null ? (Identifiable)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Identifiable.class) : null;
        } else if (name.equalsIgnoreCase("level")) {
            this.level = (Level)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("issue")) {
            this.issue = (Issue)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("count")) {
            this.count = (Integer)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Log
    extends Layer
    implements Terminal {
        protected String sourceClass;
        protected String sourceMethod;
        protected String stack;

        public Log(Node node) {
            super(node);
        }

        public String sourceClass() {
            return this.sourceClass;
        }

        public String sourceMethod() {
            return this.sourceMethod;
        }

        public String stack() {
            return this.stack;
        }

        public Log sourceClass(String value) {
            this.sourceClass = value;
            return this;
        }

        public Log sourceMethod(String value) {
            this.sourceMethod = value;
            return this;
        }

        public Log stack(String value) {
            this.stack = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("sourceClass", new ArrayList<String>(Collections.singletonList(this.sourceClass)));
            map.put("sourceMethod", new ArrayList<String>(Collections.singletonList(this.sourceMethod)));
            map.put("stack", new ArrayList<String>(Collections.singletonList(this.stack)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("sourceClass")) {
                this.sourceClass = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("sourceMethod")) {
                this.sourceMethod = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("stack")) {
                this.stack = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("sourceClass")) {
                this.sourceClass = (String)values.get(0);
            } else if (name.equalsIgnoreCase("sourceMethod")) {
                this.sourceMethod = (String)values.get(0);
            } else if (name.equalsIgnoreCase("stack")) {
                this.stack = (String)values.get(0);
            }
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }
    }

    public class Clear {
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Log log(String sourceClass, String sourceMethod, String stack) {
            Log newElement = (Log)IssueReport.this.core$().graph().concept(Log.class).createNode(this.name, IssueReport.this.core$()).as(Log.class);
            newElement.core$().set((Layer)newElement, "sourceClass", Collections.singletonList(sourceClass));
            newElement.core$().set((Layer)newElement, "sourceMethod", Collections.singletonList(sourceMethod));
            newElement.core$().set((Layer)newElement, "stack", Collections.singletonList(stack));
            return newElement;
        }
    }

    public static enum Level {
        Warn,
        Error;

    }

    public static enum Status {
        Open,
        Solved,
        Closed;

    }
}

