/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class Identifiable
extends Layer
implements Terminal {
    protected String label;
    protected List<Issue> activeIssueSensors = new ArrayList<Issue>();
    protected List<Issue> currentIssues = new ArrayList<Issue>();
    protected List<Responsible> responsibles = new ArrayList<Responsible>();

    public Identifiable(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public List<Issue> activeIssueSensors() {
        return this.activeIssueSensors;
    }

    public List<Issue> currentIssues() {
        return this.currentIssues;
    }

    public List<Responsible> responsibles() {
        return this.responsibles;
    }

    public Responsible responsibles(int index) {
        return this.responsibles.get(index);
    }

    public List<Responsible> responsibles(Predicate<Responsible> predicate) {
        return this.responsibles().stream().filter(predicate).collect(Collectors.toList());
    }

    public Identifiable label(String value) {
        this.label = value;
        return this;
    }

    public Identifiable activeIssueSensors(List<Issue> values) {
        this.activeIssueSensors = values;
        return this;
    }

    public Identifiable currentIssues(List<Issue> values) {
        this.currentIssues = values;
        return this;
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("activeIssueSensors", this.activeIssueSensors);
        map.put("currentIssues", this.currentIssues);
        map.put("responsibles", this.responsibles);
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("activeIssueSensors")) {
            this.activeIssueSensors = WordLoader.load(values, Issue.class, (Layer)this);
        } else if (name.equalsIgnoreCase("currentIssues")) {
            this.currentIssues = WordLoader.load(values, Issue.class, (Layer)this);
        } else if (name.equalsIgnoreCase("responsibles")) {
            this.responsibles = NodeLoader.load(values, Responsible.class, (Layer)this);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("activeIssueSensors")) {
            this.activeIssueSensors = new ArrayList(values);
        } else if (name.equalsIgnoreCase("currentIssues")) {
            this.currentIssues = new ArrayList(values);
        } else if (name.equalsIgnoreCase("responsibles")) {
            this.responsibles = values.stream().map(s -> (Responsible)this.graph().core$().load(((Layer)s).core$().id()).as(Responsible.class)).collect(Collectors.toList());
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

