/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractDevice;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Consumer;

public class Device
extends AbstractDevice {
    private DeviceStatus status;

    public Device(Node node) {
        super(node);
    }

    public void update(Consumer<Device> updater) {
        DeviceStatus status = this.status();
        if (status != null) {
            double temperature = status.temperature();
            if (temperature < this.temperature().min()) {
                this.temperature().min(temperature);
            } else if (temperature > this.temperature().max()) {
                this.temperature().max(temperature);
            }
            updater.accept(this);
        }
    }

    @Override
    public DeviceStatus status() {
        if (this.status != null) {
            return this.status;
        }
        if (this.statusRef() == null || this.statusRef().isEmpty()) {
            return null;
        }
        Node node = this.graph().core$().clone().load(this.statusRef(), false);
        return node != null ? (this.status = (DeviceStatus)node.as(DeviceStatus.class)) : null;
    }

    @Override
    public DeviceStatus status(Instant ts) {
        return this.status();
    }

    public Asset status(DeviceStatus status) {
        this.statusRef = status.core$().id();
        this.status = status;
        return this;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equals("statusRef")) {
            this.status();
        }
    }

    @Override
    public boolean isCompromised() {
        return this.isDisconnected() || this.lowBattery() || this.isHot() || this.isUnPlugged() || !this.isScreenOn();
    }

    @Override
    public boolean isDisconnected() {
        return this.status == null || this.status() != null && this.status().created().until(Instant.now(), ChronoUnit.HOURS) > (long)this.graph().configuration().disconnectedTimeThreshold();
    }

    public boolean isDisconnected(Instant ts) {
        return this.status(ts) == null;
    }

    public boolean veryLowBattery() {
        return this.status().battery() < (double)this.graph().configuration().deviceLowBatteryThreshold();
    }

    public boolean lowBattery() {
        return this.status().battery() < (double)this.graph().configuration().deviceBatteryThreshold();
    }

    public boolean lowBattery(Instant ts) {
        return this.status(ts).battery() < (double)this.graph().configuration().deviceBatteryThreshold();
    }

    public boolean isHot() {
        return this.status().temperature() >= (double)this.graph().configuration().deviceTemperatureThreshold();
    }

    public boolean isHot(Instant ts) {
        return this.status(ts).temperature() >= (double)this.graph().configuration().deviceTemperatureThreshold();
    }

    public boolean isUnPlugged() {
        return !this.status().isPlugged();
    }

    public boolean isScreenOn() {
        return this.status().isScreenOn();
    }

    public boolean isScreenOn(Instant ts) {
        return this.status(ts).isScreenOn();
    }

    @Override
    public boolean isRunningOutOfMemory() {
        return false;
    }

    @Override
    public boolean isRunningOutOfCpu() {
        return false;
    }

    @Override
    public boolean isRunningOutOfDisk() {
        return false;
    }

    public boolean isRunningOutOfCpu(Instant ts) {
        return false;
    }

    public String toString() {
        return this.label;
    }
}

