/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.sumus.SumusStore;
import io.intino.tara.io.Stash;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class CesarStore
extends SumusStore {
    private static final Logger logger = Logger.getRootLogger();
    private boolean firstLoad = true;

    public CesarStore(File store) {
        super(store);
    }

    public void writeStash(Stash stash, String path) {
        stash.language = stash.language == null || stash.language.isEmpty() ? "Cesar" : stash.language;
        super.writeStash(stash, path);
    }

    public Stash stashFrom(String path) {
        Stash stash = super.stashFrom(path);
        if (this.firstLoad) {
            stash.uses.addAll(this.allStashesInStore());
        }
        this.firstLoad = false;
        return stash;
    }

    public void deleteResource(URL url) {
        new File(this.storeFolder(), this.relativePathOf(url)).delete();
    }

    public void firstLoad(boolean firstLoad) {
        this.firstLoad = firstLoad;
    }

    private List<String> allStashesInStore() {
        try {
            if (!this.file.exists()) {
                return new ArrayList<String>();
            }
            ArrayList<String> stashes = new ArrayList<String>();
            stashes.addAll(this.infrastructure());
            stashes.addAll(this.projects());
            return stashes;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private List<String> infrastructure() throws IOException {
        File infrastructure = this.fileOf("infrastructure");
        return !infrastructure.exists() ? Collections.emptyList() : this.walk(infrastructure);
    }

    private List<String> projects() throws IOException {
        File projects = this.fileOf("projects");
        return !projects.exists() ? Collections.emptyList() : this.walk(projects);
    }

    private List<String> walk(File infrastructure) throws IOException {
        final ArrayList<String> result = new ArrayList<String>();
        Files.walkFileTree(infrastructure.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().toLowerCase().endsWith(".stash")) {
                    result.add(CesarStore.this.relativePathOf(file.toUri().toURL()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }
}

