/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.Utils;
import io.intino.cesar.graph.AbstractGraph;
import io.intino.cesar.graph.CesarStore;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.tara.magritte.Graph;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CesarGraph
extends AbstractGraph {
    public CesarGraph(Graph graph) {
        super(graph);
    }

    public CesarGraph(Graph graph, CesarGraph wrapper) {
        super(graph, wrapper);
    }

    public List<System> systemsOf(String project) {
        Project pr = this.projectList(p -> p.name$().equals(project)).findFirst().orElse(null);
        return pr == null ? Collections.emptyList() : pr.systemList();
    }

    public System systemFrom(String project, String name) {
        return this.systemsOf(project).stream().filter(s -> s.name$().equals(name)).findFirst().orElse(null);
    }

    public System systemFrom(String project, String system, String serverID) {
        return this.systemsOf(project).stream().filter(s -> s.name$().equals(serverID + ":" + Utils.normalizedID(system))).findFirst().orElse(null);
    }

    public Server serverOf(System system) {
        return (Server)system.consul().core$().ownerAs(Server.class);
    }

    public Server server(String name) {
        for (Server server : this.servers()) {
            if (!server.name$().equals(name)) continue;
            return server;
        }
        return null;
    }

    public Feeder feeder(String name) {
        for (Feeder feeder : this.feederList()) {
            if (!feeder.name$().equals(name)) continue;
            return feeder;
        }
        return null;
    }

    public List<Server> servers() {
        return this.serverList(s -> !s.i$(Feeder.class)).collect(Collectors.toList());
    }

    public List<Device> devices() {
        return this.deviceList();
    }

    public Project project(String name) {
        return this.projectList().stream().filter(project -> project.name$().equals(name)).findFirst().orElse(null);
    }

    public Device device(String name) {
        return this.deviceList().stream().filter(device -> device.name$().equals(name)).findFirst().orElse(null);
    }

    public CesarStore store() {
        return (CesarStore)this.core$().store();
    }
}

