/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.Operation;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractSystem
extends Identifiable
implements Component,
Terminal {
    protected String url;
    protected URL logo;
    protected boolean started;
    protected boolean debugging;
    protected int debugPort;
    protected ServerConsul consul;
    protected List<Issue> activeIssueSensors = new ArrayList<Issue>();
    protected String statusRef;
    protected Artifact artifact;
    protected List<Deployment> deploymentList = new ArrayList<Deployment>();
    protected Operations operations;
    protected Registry registry;

    public AbstractSystem(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public URL logo() {
        return this.logo;
    }

    public boolean started() {
        return this.started;
    }

    public boolean debugging() {
        return this.debugging;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public ServerConsul consul() {
        return this.consul;
    }

    public String statusRef() {
        return this.statusRef;
    }

    public System url(String value) {
        this.url = value;
        return (System)this;
    }

    public System logo(URL url, String destiny) {
        this.logo = this.graph().core$().save(url, destiny, this.logo, this.core$());
        return (System)this;
    }

    public System logo(InputStream stream, String destiny) {
        this.logo = this.graph().core$().save(stream, destiny, this.logo, this.core$());
        return (System)this;
    }

    public System started(boolean value) {
        this.started = value;
        return (System)this;
    }

    public System debugging(boolean value) {
        this.debugging = value;
        return (System)this;
    }

    public System debugPort(int value) {
        this.debugPort = value;
        return (System)this;
    }

    public System consul(ServerConsul value) {
        this.consul = value;
        return (System)this;
    }

    public System statusRef(String value) {
        this.statusRef = value;
        return (System)this;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public List<Deployment> deploymentList() {
        return Collections.unmodifiableList(this.deploymentList);
    }

    public Deployment deployment(int index) {
        return this.deploymentList.get(index);
    }

    public List<Deployment> deploymentList(Predicate<Deployment> predicate) {
        return this.deploymentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Operations operations() {
        return this.operations;
    }

    public Registry registry() {
        return this.registry;
    }

    public System artifact(Artifact value) {
        this.artifact = value;
        return (System)this;
    }

    public System operations(Operations value) {
        this.operations = value;
        return (System)this;
    }

    public System registry(Registry value) {
        this.registry = value;
        return (System)this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.artifact != null) {
            components.add(this.artifact.core$());
        }
        new ArrayList<Deployment>(this.deploymentList).forEach(c -> components.add(c.core$()));
        if (this.operations != null) {
            components.add(this.operations.core$());
        }
        if (this.registry != null) {
            components.add(this.registry.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("logo", new ArrayList<URL>(Collections.singletonList(this.logo)));
        map.put("started", new ArrayList<Boolean>(Collections.singletonList(this.started)));
        map.put("debugging", new ArrayList<Boolean>(Collections.singletonList(this.debugging)));
        map.put("debugPort", new ArrayList<Integer>(Collections.singletonList(this.debugPort)));
        map.put("consul", this.consul != null ? new ArrayList<ServerConsul>(Collections.singletonList(this.consul)) : Collections.emptyList());
        map.put("statusRef", new ArrayList<String>(Collections.singletonList(this.statusRef)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Artifact")) {
            this.artifact = (Artifact)node.as(Artifact.class);
        }
        if (node.is("System$Deployment")) {
            this.deploymentList.add((Deployment)node.as(Deployment.class));
        }
        if (node.is("System$Operations")) {
            this.operations = (Operations)node.as(Operations.class);
        }
        if (node.is("System$Registry")) {
            this.registry = (Registry)node.as(Registry.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Artifact")) {
            this.artifact = null;
        }
        if (node.is("System$Deployment")) {
            this.deploymentList.remove(node.as(Deployment.class));
        }
        if (node.is("System$Operations")) {
            this.operations = null;
        }
        if (node.is("System$Registry")) {
            this.registry = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("logo")) {
            this.logo = (URL)ResourceLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("started")) {
            this.started = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("debugging")) {
            this.debugging = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = (ServerConsul)((Object)NodeLoader.load(values, ServerConsul.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("statusRef")) {
            this.statusRef = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("logo")) {
            this.logo = (URL)values.get(0);
        } else if (name.equalsIgnoreCase("started")) {
            this.started = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("debugging")) {
            this.debugging = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = values.get(0) != null ? (ServerConsul)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(ServerConsul.class) : null;
        } else if (name.equalsIgnoreCase("statusRef")) {
            this.statusRef = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Registry
    extends Layer
    implements Terminal {
        protected URL log;

        public Registry(Node node) {
            super(node);
        }

        public URL log() {
            return this.log;
        }

        public Registry log(URL url, String destiny) {
            this.log = this.graph().core$().save(url, destiny, this.log, this.core$());
            return this;
        }

        public Registry log(InputStream stream, String destiny) {
            this.log = this.graph().core$().save(stream, destiny, this.log, this.core$());
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("log", new ArrayList<URL>(Collections.singletonList(this.log)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("log")) {
                this.log = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("log")) {
                this.log = (URL)values.get(0);
            }
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }
    }

    public static class Operations
    extends Layer
    implements Terminal {
        protected int port;
        protected List<Operation> operationList = new ArrayList<Operation>();

        public Operations(Node node) {
            super(node);
        }

        public int port() {
            return this.port;
        }

        public Operations port(int value) {
            this.port = value;
            return this;
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
            public void operation(Predicate<Operation> filter) {
                new ArrayList<Operation>(Operations.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Operation operation(String name, List<String> parameters, String description) {
                Operation newElement = (Operation)Operations.this.core$().graph().concept(Operation.class).createNode(this.name, Operations.this.core$()).as(Operation.class);
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "parameters", parameters);
                newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }
        }
    }

    public static class Deployment
    extends Layer
    implements Terminal {
        protected boolean success;
        protected Prerequisites prerequisites;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();

        public Deployment(Node node) {
            super(node);
        }

        public boolean success() {
            return this.success;
        }

        public Deployment success(boolean value) {
            this.success = value;
            return this;
        }

        public Prerequisites prerequisites() {
            return this.prerequisites;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Deployment prerequisites(Prerequisites value) {
            this.prerequisites = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.prerequisites != null) {
                components.add(this.prerequisites.core$());
            }
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("success", new ArrayList<Boolean>(Collections.singletonList(this.success)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("System$Deployment$Prerequisites")) {
                this.prerequisites = (Prerequisites)node.as(Prerequisites.class);
            }
            if (node.is("System$Deployment$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("System$Deployment$Prerequisites")) {
                this.prerequisites = null;
            }
            if (node.is("System$Deployment$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("success")) {
                this.success = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("success")) {
                this.success = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public static class Parameter
        extends Layer
        implements Terminal {
            protected String name;
            protected String value;

            public Parameter(Node node) {
                super(node);
            }

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public Parameter name(String value) {
                this.name = value;
                return this;
            }

            public Parameter value(String value) {
                this.value = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            public CesarGraph graph() {
                return (CesarGraph)this.core$().graph().as(CesarGraph.class);
            }
        }

        public static class Prerequisites
        extends Layer
        implements Terminal {
            protected int memory;
            protected double hdd;
            protected Performance performance;

            public Prerequisites(Node node) {
                super(node);
            }

            public int memory() {
                return this.memory;
            }

            public double hdd() {
                return this.hdd;
            }

            public Performance performance() {
                return this.performance;
            }

            public Prerequisites memory(int value) {
                this.memory = value;
                return this;
            }

            public Prerequisites hdd(double value) {
                this.hdd = value;
                return this;
            }

            public Prerequisites performance(Performance value) {
                this.performance = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("memory", new ArrayList<Integer>(Collections.singletonList(this.memory)));
                map.put("hdd", new ArrayList<Double>(Collections.singletonList(this.hdd)));
                map.put("performance", new ArrayList<Performance>(Collections.singletonList(this.performance)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("memory")) {
                    this.memory = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = (Performance)((Object)WordLoader.load(values, Performance.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("memory")) {
                    this.memory = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = (Performance)((Object)values.get(0));
                }
            }

            public CesarGraph graph() {
                return (CesarGraph)this.core$().graph().as(CesarGraph.class);
            }

            public static enum Performance {
                High,
                Medium,
                Low;

            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Deployment.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Prerequisites prerequisites() {
                Prerequisites newElement = (Prerequisites)Deployment.this.core$().graph().concept(Prerequisites.class).createNode(this.name, Deployment.this.core$()).as(Prerequisites.class);
                return newElement;
            }

            public Parameter parameter(String name, String value) {
                Parameter newElement = (Parameter)Deployment.this.core$().graph().concept(Parameter.class).createNode(this.name, Deployment.this.core$()).as(Parameter.class);
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }
    }

    public class Clear {
        public void deployment(Predicate<Deployment> filter) {
            new ArrayList<Deployment>(AbstractSystem.this.deploymentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Identifiable.Create {
        public Create(String name) {
            super(AbstractSystem.this, name);
        }

        public Artifact artifact(String group, String artifactId, String version) {
            Artifact newElement = (Artifact)AbstractSystem.this.core$().graph().concept(Artifact.class).createNode(this.name, AbstractSystem.this.core$()).as(Artifact.class);
            newElement.core$().set((Layer)newElement, "group", Collections.singletonList(group));
            newElement.core$().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Deployment deployment() {
            Deployment newElement = (Deployment)AbstractSystem.this.core$().graph().concept(Deployment.class).createNode(this.name, AbstractSystem.this.core$()).as(Deployment.class);
            return newElement;
        }

        public Operations operations() {
            Operations newElement = (Operations)AbstractSystem.this.core$().graph().concept(Operations.class).createNode(this.name, AbstractSystem.this.core$()).as(Operations.class);
            return newElement;
        }

        public Registry registry() {
            Registry newElement = (Registry)AbstractSystem.this.core$().graph().concept(Registry.class).createNode(this.name, AbstractSystem.this.core$()).as(Registry.class);
            return newElement;
        }
    }
}

