/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractAsset;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.CPU;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.HDD;
import io.intino.cesar.graph.Memory;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.functions.PortRelease;
import io.intino.cesar.graph.functions.PortReservation;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractServer
extends Asset
implements Terminal {
    protected List<Issue> activeIssueSensors = new ArrayList<Issue>();
    protected String ip;
    protected String url;
    protected Performance performance;
    protected List<Integer> debugUsedPorts = new ArrayList<Integer>();
    protected List<Integer> jmxUsedPorts = new ArrayList<Integer>();
    protected PortReservation reserveDebugPort;
    protected PortReservation reserveJMXPort;
    protected PortRelease releasePort;
    protected ServerConsul serverConsul;
    protected RemoteConnection remoteConnection;
    protected Memory memory;
    protected CPU cPU;
    protected HDD hDD;

    public AbstractServer(Node node) {
        super(node);
    }

    public String ip() {
        return this.ip;
    }

    public String url() {
        return this.url;
    }

    public Performance performance() {
        return this.performance;
    }

    public List<Integer> debugUsedPorts() {
        return this.debugUsedPorts;
    }

    public Integer debugUsedPorts(int index) {
        return this.debugUsedPorts.get(index);
    }

    public List<Integer> debugUsedPorts(Predicate<Integer> predicate) {
        return this.debugUsedPorts().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Integer> jmxUsedPorts() {
        return this.jmxUsedPorts;
    }

    public Integer jmxUsedPorts(int index) {
        return this.jmxUsedPorts.get(index);
    }

    public List<Integer> jmxUsedPorts(Predicate<Integer> predicate) {
        return this.jmxUsedPorts().stream().filter(predicate).collect(Collectors.toList());
    }

    public int reserveDebugPort() {
        return this.reserveDebugPort.reservePort();
    }

    public int reserveJMXPort() {
        return this.reserveJMXPort.reservePort();
    }

    public void releasePort(int port) {
        this.releasePort.release(port);
    }

    public Server ip(String value) {
        this.ip = value;
        return (Server)this;
    }

    public Server url(String value) {
        this.url = value;
        return (Server)this;
    }

    public Server performance(Performance value) {
        this.performance = value;
        return (Server)this;
    }

    public Server reserveDebugPort(PortReservation value) {
        this.reserveDebugPort = (PortReservation)FunctionLoader.load((Object)this.reserveDebugPort, (Layer)this, PortReservation.class);
        return (Server)this;
    }

    public Server reserveJMXPort(PortReservation value) {
        this.reserveJMXPort = (PortReservation)FunctionLoader.load((Object)this.reserveJMXPort, (Layer)this, PortReservation.class);
        return (Server)this;
    }

    public Server releasePort(PortRelease value) {
        this.releasePort = (PortRelease)FunctionLoader.load((Object)this.releasePort, (Layer)this, PortRelease.class);
        return (Server)this;
    }

    public ServerConsul serverConsul() {
        return this.serverConsul;
    }

    public RemoteConnection remoteConnection() {
        return this.remoteConnection;
    }

    public Memory memory() {
        return this.memory;
    }

    public CPU cPU() {
        return this.cPU;
    }

    public HDD hDD() {
        return this.hDD;
    }

    public Server serverConsul(ServerConsul value) {
        this.serverConsul = value;
        return (Server)this;
    }

    public Server remoteConnection(RemoteConnection value) {
        this.remoteConnection = value;
        return (Server)this;
    }

    public Server memory(Memory value) {
        this.memory = value;
        return (Server)this;
    }

    public Server cPU(CPU value) {
        this.cPU = value;
        return (Server)this;
    }

    public Server hDD(HDD value) {
        this.hDD = value;
        return (Server)this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.serverConsul != null) {
            components.add(this.serverConsul.core$());
        }
        if (this.remoteConnection != null) {
            components.add(this.remoteConnection.core$());
        }
        if (this.memory != null) {
            components.add(this.memory.core$());
        }
        if (this.cPU != null) {
            components.add(this.cPU.core$());
        }
        if (this.hDD != null) {
            components.add(this.hDD.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("ip", new ArrayList<String>(Collections.singletonList(this.ip)));
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("performance", new ArrayList<Performance>(Collections.singletonList(this.performance)));
        map.put("debugUsedPorts", this.debugUsedPorts);
        map.put("jmxUsedPorts", this.jmxUsedPorts);
        map.put("reserveDebugPort", this.reserveDebugPort != null ? new ArrayList<PortReservation>(Collections.singletonList(this.reserveDebugPort)) : Collections.emptyList());
        map.put("reserveJMXPort", this.reserveJMXPort != null ? new ArrayList<PortReservation>(Collections.singletonList(this.reserveJMXPort)) : Collections.emptyList());
        map.put("releasePort", this.releasePort != null ? new ArrayList<PortRelease>(Collections.singletonList(this.releasePort)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = (ServerConsul)node.as(ServerConsul.class);
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = (RemoteConnection)node.as(RemoteConnection.class);
        }
        if (node.is("Memory")) {
            this.memory = (Memory)node.as(Memory.class);
        }
        if (node.is("CPU")) {
            this.cPU = (CPU)node.as(CPU.class);
        }
        if (node.is("HDD")) {
            this.hDD = (HDD)node.as(HDD.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = null;
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = null;
        }
        if (node.is("Memory")) {
            this.memory = null;
        }
        if (node.is("CPU")) {
            this.cPU = null;
        }
        if (node.is("HDD")) {
            this.hDD = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("ip")) {
            this.ip = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("performance")) {
            this.performance = (Performance)((Object)WordLoader.load(values, Performance.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("debugUsedPorts")) {
            this.debugUsedPorts = IntegerLoader.load(values, (Layer)this);
        } else if (name.equalsIgnoreCase("jmxUsedPorts")) {
            this.jmxUsedPorts = IntegerLoader.load(values, (Layer)this);
        } else if (name.equalsIgnoreCase("reserveDebugPort")) {
            this.reserveDebugPort = (PortReservation)FunctionLoader.load(values, (Layer)this, PortReservation.class).get(0);
        } else if (name.equalsIgnoreCase("reserveJMXPort")) {
            this.reserveJMXPort = (PortReservation)FunctionLoader.load(values, (Layer)this, PortReservation.class).get(0);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = (PortRelease)FunctionLoader.load(values, (Layer)this, PortRelease.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("ip")) {
            this.ip = (String)values.get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("performance")) {
            this.performance = (Performance)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("debugUsedPorts")) {
            this.debugUsedPorts = new ArrayList(values);
        } else if (name.equalsIgnoreCase("jmxUsedPorts")) {
            this.jmxUsedPorts = new ArrayList(values);
        } else if (name.equalsIgnoreCase("reserveDebugPort")) {
            this.reserveDebugPort = (PortReservation)FunctionLoader.load(values.get(0), (Layer)this, PortReservation.class);
        } else if (name.equalsIgnoreCase("reserveJMXPort")) {
            this.reserveJMXPort = (PortReservation)FunctionLoader.load(values.get(0), (Layer)this, PortReservation.class);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = (PortRelease)FunctionLoader.load(values.get(0), (Layer)this, PortRelease.class);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class RemoteConnection
    extends Layer
    implements Terminal {
        protected String user;
        protected String url;
        protected int port;

        public RemoteConnection(Node node) {
            super(node);
        }

        public String user() {
            return this.user;
        }

        public String url() {
            return this.url;
        }

        public int port() {
            return this.port;
        }

        public RemoteConnection user(String value) {
            this.user = value;
            return this;
        }

        public RemoteConnection url(String value) {
            this.url = value;
            return this;
        }

        public RemoteConnection port(int value) {
            this.port = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = (String)values.get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)values.get(0);
            }
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }
    }

    public class Clear {
    }

    public class Create
    extends AbstractAsset.Create {
        public Create(String name) {
            super(name);
        }

        public ServerConsul serverConsul(String version) {
            ServerConsul newElement = (ServerConsul)AbstractServer.this.core$().graph().concept(ServerConsul.class).createNode(this.name, AbstractServer.this.core$()).as(ServerConsul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public RemoteConnection remoteConnection(String user, String url, int port) {
            RemoteConnection newElement = (RemoteConnection)AbstractServer.this.core$().graph().concept(RemoteConnection.class).createNode(this.name, AbstractServer.this.core$()).as(RemoteConnection.class);
            newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
            return newElement;
        }

        public Memory memory(double capacity) {
            Memory newElement = (Memory)AbstractServer.this.core$().graph().concept(Memory.class).createNode(this.name, AbstractServer.this.core$()).as(Memory.class);
            newElement.core$().set((Layer)newElement, "capacity", Collections.singletonList(capacity));
            return newElement;
        }

        public CPU cPU(int cores, double frequency) {
            CPU newElement = (CPU)AbstractServer.this.core$().graph().concept(CPU.class).createNode(this.name, AbstractServer.this.core$()).as(CPU.class);
            newElement.core$().set((Layer)newElement, "cores", Collections.singletonList(cores));
            newElement.core$().set((Layer)newElement, "frequency", Collections.singletonList(frequency));
            return newElement;
        }

        public HDD hDD(int frequency, double capacity) {
            HDD newElement = (HDD)AbstractServer.this.core$().graph().concept(HDD.class).createNode(this.name, AbstractServer.this.core$()).as(HDD.class);
            newElement.core$().set((Layer)newElement, "frequency", Collections.singletonList(frequency));
            newElement.core$().set((Layer)newElement, "capacity", Collections.singletonList(capacity));
            return newElement;
        }
    }

    public static enum Performance {
        High,
        Medium,
        Low;

    }
}

