/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Datalake;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.System;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractProject
extends Layer
implements Terminal {
    protected String label;
    protected List<System> systemList = new ArrayList<System>();

    public AbstractProject(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public Project label(String value) {
        this.label = value;
        return (Project)this;
    }

    public List<System> systemList() {
        return Collections.unmodifiableList(this.systemList);
    }

    public System system(int index) {
        return this.systemList.get(index);
    }

    public List<System> systemList(Predicate<System> predicate) {
        return this.systemList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<System>(this.systemList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("System")) {
            this.systemList.add((System)node.as(System.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("System")) {
            this.systemList.remove(node.as(System.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public class Clear {
        public void system(Predicate<System> filter) {
            new ArrayList<System>(AbstractProject.this.systemList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public System system(String label, String url) {
            System newElement = (System)AbstractProject.this.core$().graph().concept(System.class).createNode(this.name, AbstractProject.this.core$()).as(System.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }

        public Datalake datalake(String label, String url) {
            Datalake newElement = (Datalake)AbstractProject.this.core$().graph().concept(Datalake.class).createNode(this.name, AbstractProject.this.core$()).as(Datalake.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }
    }
}

