/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractIssueTracker
extends Layer
implements Terminal {
    protected List<IssueReport> issueReportList = new ArrayList<IssueReport>();

    public AbstractIssueTracker(Node node) {
        super(node);
    }

    public List<IssueReport> issueReportList() {
        return Collections.unmodifiableList(this.issueReportList);
    }

    public IssueReport issueReport(int index) {
        return this.issueReportList.get(index);
    }

    public List<IssueReport> issueReportList(Predicate<IssueReport> predicate) {
        return this.issueReportList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<IssueReport>(this.issueReportList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("IssueReport")) {
            this.issueReportList.add((IssueReport)node.as(IssueReport.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("IssueReport")) {
            this.issueReportList.remove(node.as(IssueReport.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public class Clear {
        public void issueReport(Predicate<IssueReport> filter) {
            new ArrayList<IssueReport>(AbstractIssueTracker.this.issueReportList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public IssueReport issueReport(Identifiable target, IssueReport.Level level, Issue issue) {
            IssueReport newElement = (IssueReport)AbstractIssueTracker.this.core$().graph().concept(IssueReport.class).createNode(this.name, AbstractIssueTracker.this.core$()).as(IssueReport.class);
            newElement.core$().set((Layer)newElement, "target", Collections.singletonList(target));
            newElement.core$().set((Layer)newElement, "level", Collections.singletonList(level));
            newElement.core$().set((Layer)newElement, "issue", Collections.singletonList(issue));
            return newElement;
        }
    }
}

