/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceBoot;
import io.intino.cesar.graph.DeviceCrash;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.FeederStatus;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueTracker;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.Status;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemStatus;
import io.intino.cesar.graph.emailcontact.EmailContactResponsible;
import io.intino.cesar.graph.slackcontact.SlackContactResponsible;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Ticket;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Project> projectList = new ArrayList<Project>();
    private List<Asset> assetList = new ArrayList<Asset>();
    private List<Server> serverList = new ArrayList<Server>();
    private List<Device> deviceList = new ArrayList<Device>();
    private List<Feeder> feederList = new ArrayList<Feeder>();
    private IssueTracker issueTracker;
    private List<Consul> consulList = new ArrayList<Consul>();
    private List<Identifiable> identifiableList = new ArrayList<Identifiable>();
    private List<Responsible> responsibleList = new ArrayList<Responsible>();
    private List<EmailContactResponsible> emailContactResponsibleList = new ArrayList<EmailContactResponsible>();
    private List<SlackContactResponsible> slackContactResponsibleList = new ArrayList<SlackContactResponsible>();
    private Configuration configuration;
    private Olap cesarOlap;
    private Ticket meanTemperatureTicket;
    private Ticket meanBatteryTicket;
    private Ticket screenTicket;
    private Metric temperature;
    private Metric amount;
    private Metric percentage;
    private List<Status> statusList = new ArrayList<Status>();
    private List<DeviceStatus> deviceStatusList = new ArrayList<DeviceStatus>();
    private List<ServerStatus> serverStatusList = new ArrayList<ServerStatus>();
    private List<FeederStatus> feederStatusList = new ArrayList<FeederStatus>();
    private List<SystemStatus> systemStatusList = new ArrayList<SystemStatus>();
    private List<DeviceCrash> deviceCrashList = new ArrayList<DeviceCrash>();
    private List<DeviceBoot> deviceBootList = new ArrayList<DeviceBoot>();
    private Cube deviceCube;
    private Cube feederCube;
    private Cube serverCube;
    private Cube systemCube;
    private Categorization unitCategorization;
    private Categorization statusCategorization;
    private Categorization screenCategorization;
    private Categorization batteryCategorization;
    private Categorization pluggedCategorization;
    private Categorization connectionCategorization;
    private Categorization systemCategorization;
    private Categorization deviceCategorization;
    private NameSpace default$;
    private Palette palette;
    private Map<String, Indexer> index = this.fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Cesar");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Cesar");
        this.projectList = new ArrayList<Project>(wrapper.projectList);
        this.assetList = new ArrayList<Asset>(wrapper.assetList);
        this.serverList = new ArrayList<Server>(wrapper.serverList);
        this.deviceList = new ArrayList<Device>(wrapper.deviceList);
        this.feederList = new ArrayList<Feeder>(wrapper.feederList);
        this.issueTracker = wrapper.issueTracker;
        this.consulList = new ArrayList<Consul>(wrapper.consulList);
        this.identifiableList = new ArrayList<Identifiable>(wrapper.identifiableList);
        this.responsibleList = new ArrayList<Responsible>(wrapper.responsibleList);
        this.emailContactResponsibleList = new ArrayList<EmailContactResponsible>(wrapper.emailContactResponsibleList);
        this.slackContactResponsibleList = new ArrayList<SlackContactResponsible>(wrapper.slackContactResponsibleList);
        this.configuration = wrapper.configuration;
        this.cesarOlap = wrapper.cesarOlap;
        this.meanTemperatureTicket = wrapper.meanTemperatureTicket;
        this.meanBatteryTicket = wrapper.meanBatteryTicket;
        this.screenTicket = wrapper.screenTicket;
        this.temperature = wrapper.temperature;
        this.amount = wrapper.amount;
        this.percentage = wrapper.percentage;
        this.statusList = new ArrayList<Status>(wrapper.statusList);
        this.deviceStatusList = new ArrayList<DeviceStatus>(wrapper.deviceStatusList);
        this.serverStatusList = new ArrayList<ServerStatus>(wrapper.serverStatusList);
        this.feederStatusList = new ArrayList<FeederStatus>(wrapper.feederStatusList);
        this.systemStatusList = new ArrayList<SystemStatus>(wrapper.systemStatusList);
        this.deviceCrashList = new ArrayList<DeviceCrash>(wrapper.deviceCrashList);
        this.deviceBootList = new ArrayList<DeviceBoot>(wrapper.deviceBootList);
        this.deviceCube = wrapper.deviceCube;
        this.feederCube = wrapper.feederCube;
        this.serverCube = wrapper.serverCube;
        this.systemCube = wrapper.systemCube;
        this.unitCategorization = wrapper.unitCategorization;
        this.statusCategorization = wrapper.statusCategorization;
        this.screenCategorization = wrapper.screenCategorization;
        this.batteryCategorization = wrapper.batteryCategorization;
        this.pluggedCategorization = wrapper.pluggedCategorization;
        this.connectionCategorization = wrapper.connectionCategorization;
        this.systemCategorization = wrapper.systemCategorization;
        this.deviceCategorization = wrapper.deviceCategorization;
        this.default$ = wrapper.default$;
        this.palette = wrapper.palette;
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this.index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this.index.containsKey(c.id())) continue;
            this.index.get(c.id()).add(node);
        }
        if (this.index.containsKey(node.id())) {
            this.index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this.index.containsKey(c.id())) continue;
            this.index.get(c.id()).remove(node);
        }
        if (this.index.containsKey(node.id())) {
            this.index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Project> projectList() {
        return this.projectList;
    }

    public List<Asset> assetList() {
        return this.assetList;
    }

    public List<Server> serverList() {
        return this.serverList;
    }

    public List<Device> deviceList() {
        return this.deviceList;
    }

    public List<Feeder> feederList() {
        return this.feederList;
    }

    public IssueTracker issueTracker() {
        return this.issueTracker;
    }

    public List<Consul> consulList() {
        return this.consulList;
    }

    public List<Identifiable> identifiableList() {
        return this.identifiableList;
    }

    public List<Responsible> responsibleList() {
        return this.responsibleList;
    }

    public List<EmailContactResponsible> emailContactResponsibleList() {
        return this.emailContactResponsibleList;
    }

    public List<SlackContactResponsible> slackContactResponsibleList() {
        return this.slackContactResponsibleList;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Olap cesarOlap() {
        return this.cesarOlap;
    }

    public Ticket meanTemperatureTicket() {
        return this.meanTemperatureTicket;
    }

    public Ticket meanBatteryTicket() {
        return this.meanBatteryTicket;
    }

    public Ticket screenTicket() {
        return this.screenTicket;
    }

    public Metric temperature() {
        return this.temperature;
    }

    public Metric amount() {
        return this.amount;
    }

    public Metric percentage() {
        return this.percentage;
    }

    public List<Status> statusList() {
        return this.statusList;
    }

    public List<DeviceStatus> deviceStatusList() {
        return this.deviceStatusList;
    }

    public List<ServerStatus> serverStatusList() {
        return this.serverStatusList;
    }

    public List<FeederStatus> feederStatusList() {
        return this.feederStatusList;
    }

    public List<SystemStatus> systemStatusList() {
        return this.systemStatusList;
    }

    public List<DeviceCrash> deviceCrashList() {
        return this.deviceCrashList;
    }

    public List<DeviceBoot> deviceBootList() {
        return this.deviceBootList;
    }

    public Cube deviceCube() {
        return this.deviceCube;
    }

    public Cube feederCube() {
        return this.feederCube;
    }

    public Cube serverCube() {
        return this.serverCube;
    }

    public Cube systemCube() {
        return this.systemCube;
    }

    public Categorization unitCategorization() {
        return this.unitCategorization;
    }

    public Categorization statusCategorization() {
        return this.statusCategorization;
    }

    public Categorization screenCategorization() {
        return this.screenCategorization;
    }

    public Categorization batteryCategorization() {
        return this.batteryCategorization;
    }

    public Categorization pluggedCategorization() {
        return this.pluggedCategorization;
    }

    public Categorization connectionCategorization() {
        return this.connectionCategorization;
    }

    public Categorization systemCategorization() {
        return this.systemCategorization;
    }

    public Categorization deviceCategorization() {
        return this.deviceCategorization;
    }

    public NameSpace default$() {
        return this.default$;
    }

    public Palette palette() {
        return this.palette;
    }

    public Stream<Project> projectList(Predicate<Project> filter) {
        return this.projectList.stream().filter(filter);
    }

    public Project project(int index) {
        return this.projectList.get(index);
    }

    public Stream<Asset> assetList(Predicate<Asset> filter) {
        return this.assetList.stream().filter(filter);
    }

    public Asset asset(int index) {
        return this.assetList.get(index);
    }

    public Stream<Server> serverList(Predicate<Server> filter) {
        return this.serverList.stream().filter(filter);
    }

    public Server server(int index) {
        return this.serverList.get(index);
    }

    public Stream<Device> deviceList(Predicate<Device> filter) {
        return this.deviceList.stream().filter(filter);
    }

    public Device device(int index) {
        return this.deviceList.get(index);
    }

    public Stream<Feeder> feederList(Predicate<Feeder> filter) {
        return this.feederList.stream().filter(filter);
    }

    public Feeder feeder(int index) {
        return this.feederList.get(index);
    }

    public Stream<Consul> consulList(Predicate<Consul> filter) {
        return this.consulList.stream().filter(filter);
    }

    public Consul consul(int index) {
        return this.consulList.get(index);
    }

    public Stream<Identifiable> identifiableList(Predicate<Identifiable> filter) {
        return this.identifiableList.stream().filter(filter);
    }

    public Identifiable identifiable(int index) {
        return this.identifiableList.get(index);
    }

    public Stream<Responsible> responsibleList(Predicate<Responsible> filter) {
        return this.responsibleList.stream().filter(filter);
    }

    public Responsible responsible(int index) {
        return this.responsibleList.get(index);
    }

    public Stream<EmailContactResponsible> emailContactResponsibleList(Predicate<EmailContactResponsible> filter) {
        return this.emailContactResponsibleList.stream().filter(filter);
    }

    public EmailContactResponsible emailContactResponsible(int index) {
        return this.emailContactResponsibleList.get(index);
    }

    public Stream<SlackContactResponsible> slackContactResponsibleList(Predicate<SlackContactResponsible> filter) {
        return this.slackContactResponsibleList.stream().filter(filter);
    }

    public SlackContactResponsible slackContactResponsible(int index) {
        return this.slackContactResponsibleList.get(index);
    }

    public Stream<Status> statusList(Predicate<Status> filter) {
        return this.statusList.stream().filter(filter);
    }

    public Status status(int index) {
        return this.statusList.get(index);
    }

    public Stream<DeviceStatus> deviceStatusList(Predicate<DeviceStatus> filter) {
        return this.deviceStatusList.stream().filter(filter);
    }

    public DeviceStatus deviceStatus(int index) {
        return this.deviceStatusList.get(index);
    }

    public Stream<ServerStatus> serverStatusList(Predicate<ServerStatus> filter) {
        return this.serverStatusList.stream().filter(filter);
    }

    public ServerStatus serverStatus(int index) {
        return this.serverStatusList.get(index);
    }

    public Stream<FeederStatus> feederStatusList(Predicate<FeederStatus> filter) {
        return this.feederStatusList.stream().filter(filter);
    }

    public FeederStatus feederStatus(int index) {
        return this.feederStatusList.get(index);
    }

    public Stream<SystemStatus> systemStatusList(Predicate<SystemStatus> filter) {
        return this.systemStatusList.stream().filter(filter);
    }

    public SystemStatus systemStatus(int index) {
        return this.systemStatusList.get(index);
    }

    public Stream<DeviceCrash> deviceCrashList(Predicate<DeviceCrash> filter) {
        return this.deviceCrashList.stream().filter(filter);
    }

    public DeviceCrash deviceCrash(int index) {
        return this.deviceCrashList.get(index);
    }

    public Stream<DeviceBoot> deviceBootList(Predicate<DeviceBoot> filter) {
        return this.deviceBootList.stream().filter(filter);
    }

    public DeviceBoot deviceBoot(int index) {
        return this.deviceBootList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> fillIndex() {
        return new HashMap<String, Indexer>(){
            {
                this.put("Project", new Indexer(node -> AbstractGraph.this.projectList.add(node.as(Project.class)), node -> AbstractGraph.this.projectList.remove(node.as(Project.class)), () -> AbstractGraph.this.projectList.clear()));
                this.put("Asset", new Indexer(node -> AbstractGraph.this.assetList.add(node.as(Asset.class)), node -> AbstractGraph.this.assetList.remove(node.as(Asset.class)), () -> AbstractGraph.this.assetList.clear()));
                this.put("Server", new Indexer(node -> AbstractGraph.this.serverList.add(node.as(Server.class)), node -> AbstractGraph.this.serverList.remove(node.as(Server.class)), () -> AbstractGraph.this.serverList.clear()));
                this.put("Device", new Indexer(node -> AbstractGraph.this.deviceList.add(node.as(Device.class)), node -> AbstractGraph.this.deviceList.remove(node.as(Device.class)), () -> AbstractGraph.this.deviceList.clear()));
                this.put("Feeder", new Indexer(node -> AbstractGraph.this.feederList.add(node.as(Feeder.class)), node -> AbstractGraph.this.feederList.remove(node.as(Feeder.class)), () -> AbstractGraph.this.feederList.clear()));
                this.put("IssueTracker", new Indexer(node -> AbstractGraph.this.issueTracker = (IssueTracker)node.as(IssueTracker.class), node -> AbstractGraph.this.issueTracker = null, () -> AbstractGraph.this.issueTracker = null));
                this.put("Consul", new Indexer(node -> AbstractGraph.this.consulList.add(node.as(Consul.class)), node -> AbstractGraph.this.consulList.remove(node.as(Consul.class)), () -> AbstractGraph.this.consulList.clear()));
                this.put("Identifiable", new Indexer(node -> AbstractGraph.this.identifiableList.add(node.as(Identifiable.class)), node -> AbstractGraph.this.identifiableList.remove(node.as(Identifiable.class)), () -> AbstractGraph.this.identifiableList.clear()));
                this.put("Responsible", new Indexer(node -> AbstractGraph.this.responsibleList.add(node.as(Responsible.class)), node -> AbstractGraph.this.responsibleList.remove(node.as(Responsible.class)), () -> AbstractGraph.this.responsibleList.clear()));
                this.put("EmailContact#Responsible", new Indexer(node -> AbstractGraph.this.emailContactResponsibleList.add(node.as(EmailContactResponsible.class)), node -> AbstractGraph.this.emailContactResponsibleList.remove(node.as(EmailContactResponsible.class)), () -> AbstractGraph.this.emailContactResponsibleList.clear()));
                this.put("SlackContact#Responsible", new Indexer(node -> AbstractGraph.this.slackContactResponsibleList.add(node.as(SlackContactResponsible.class)), node -> AbstractGraph.this.slackContactResponsibleList.remove(node.as(SlackContactResponsible.class)), () -> AbstractGraph.this.slackContactResponsibleList.clear()));
                this.put("Configuration", new Indexer(node -> AbstractGraph.this.configuration = (Configuration)node.as(Configuration.class), node -> AbstractGraph.this.configuration = null, () -> AbstractGraph.this.configuration = null));
                this.put("Cesar#cesarOlap", new Indexer(node -> AbstractGraph.this.cesarOlap = (Olap)node.as(Olap.class), node -> AbstractGraph.this.cesarOlap = null, () -> AbstractGraph.this.cesarOlap = null));
                this.put("Cesar#meanTemperatureTicket", new Indexer(node -> AbstractGraph.this.meanTemperatureTicket = (Ticket)node.as(Ticket.class), node -> AbstractGraph.this.meanTemperatureTicket = null, () -> AbstractGraph.this.meanTemperatureTicket = null));
                this.put("Cesar#meanBatteryTicket", new Indexer(node -> AbstractGraph.this.meanBatteryTicket = (Ticket)node.as(Ticket.class), node -> AbstractGraph.this.meanBatteryTicket = null, () -> AbstractGraph.this.meanBatteryTicket = null));
                this.put("Cesar#screenTicket", new Indexer(node -> AbstractGraph.this.screenTicket = (Ticket)node.as(Ticket.class), node -> AbstractGraph.this.screenTicket = null, () -> AbstractGraph.this.screenTicket = null));
                this.put("Cesar#temperature", new Indexer(node -> AbstractGraph.this.temperature = (Metric)node.as(Metric.class), node -> AbstractGraph.this.temperature = null, () -> AbstractGraph.this.temperature = null));
                this.put("Cesar#amount", new Indexer(node -> AbstractGraph.this.amount = (Metric)node.as(Metric.class), node -> AbstractGraph.this.amount = null, () -> AbstractGraph.this.amount = null));
                this.put("Cesar#percentage", new Indexer(node -> AbstractGraph.this.percentage = (Metric)node.as(Metric.class), node -> AbstractGraph.this.percentage = null, () -> AbstractGraph.this.percentage = null));
                this.put("Status", new Indexer(node -> AbstractGraph.this.statusList.add(node.as(Status.class)), node -> AbstractGraph.this.statusList.remove(node.as(Status.class)), () -> AbstractGraph.this.statusList.clear()));
                this.put("DeviceStatus", new Indexer(node -> AbstractGraph.this.deviceStatusList.add(node.as(DeviceStatus.class)), node -> AbstractGraph.this.deviceStatusList.remove(node.as(DeviceStatus.class)), () -> AbstractGraph.this.deviceStatusList.clear()));
                this.put("ServerStatus", new Indexer(node -> AbstractGraph.this.serverStatusList.add(node.as(ServerStatus.class)), node -> AbstractGraph.this.serverStatusList.remove(node.as(ServerStatus.class)), () -> AbstractGraph.this.serverStatusList.clear()));
                this.put("FeederStatus", new Indexer(node -> AbstractGraph.this.feederStatusList.add(node.as(FeederStatus.class)), node -> AbstractGraph.this.feederStatusList.remove(node.as(FeederStatus.class)), () -> AbstractGraph.this.feederStatusList.clear()));
                this.put("SystemStatus", new Indexer(node -> AbstractGraph.this.systemStatusList.add(node.as(SystemStatus.class)), node -> AbstractGraph.this.systemStatusList.remove(node.as(SystemStatus.class)), () -> AbstractGraph.this.systemStatusList.clear()));
                this.put("DeviceCrash", new Indexer(node -> AbstractGraph.this.deviceCrashList.add(node.as(DeviceCrash.class)), node -> AbstractGraph.this.deviceCrashList.remove(node.as(DeviceCrash.class)), () -> AbstractGraph.this.deviceCrashList.clear()));
                this.put("DeviceBoot", new Indexer(node -> AbstractGraph.this.deviceBootList.add(node.as(DeviceBoot.class)), node -> AbstractGraph.this.deviceBootList.remove(node.as(DeviceBoot.class)), () -> AbstractGraph.this.deviceBootList.clear()));
                this.put("Cesar#DeviceCube", new Indexer(node -> AbstractGraph.this.deviceCube = (Cube)node.as(Cube.class), node -> AbstractGraph.this.deviceCube = null, () -> AbstractGraph.this.deviceCube = null));
                this.put("Cesar#FeederCube", new Indexer(node -> AbstractGraph.this.feederCube = (Cube)node.as(Cube.class), node -> AbstractGraph.this.feederCube = null, () -> AbstractGraph.this.feederCube = null));
                this.put("Cesar#ServerCube", new Indexer(node -> AbstractGraph.this.serverCube = (Cube)node.as(Cube.class), node -> AbstractGraph.this.serverCube = null, () -> AbstractGraph.this.serverCube = null));
                this.put("Cesar#SystemCube", new Indexer(node -> AbstractGraph.this.systemCube = (Cube)node.as(Cube.class), node -> AbstractGraph.this.systemCube = null, () -> AbstractGraph.this.systemCube = null));
                this.put("Cesar#unitCategorization", new Indexer(node -> AbstractGraph.this.unitCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.unitCategorization = null, () -> AbstractGraph.this.unitCategorization = null));
                this.put("Cesar#statusCategorization", new Indexer(node -> AbstractGraph.this.statusCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.statusCategorization = null, () -> AbstractGraph.this.statusCategorization = null));
                this.put("Cesar#screenCategorization", new Indexer(node -> AbstractGraph.this.screenCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.screenCategorization = null, () -> AbstractGraph.this.screenCategorization = null));
                this.put("Cesar#batteryCategorization", new Indexer(node -> AbstractGraph.this.batteryCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.batteryCategorization = null, () -> AbstractGraph.this.batteryCategorization = null));
                this.put("Cesar#pluggedCategorization", new Indexer(node -> AbstractGraph.this.pluggedCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.pluggedCategorization = null, () -> AbstractGraph.this.pluggedCategorization = null));
                this.put("Cesar#connectionCategorization", new Indexer(node -> AbstractGraph.this.connectionCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.connectionCategorization = null, () -> AbstractGraph.this.connectionCategorization = null));
                this.put("Cesar#systemCategorization", new Indexer(node -> AbstractGraph.this.systemCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.systemCategorization = null, () -> AbstractGraph.this.systemCategorization = null));
                this.put("Cesar#deviceCategorization", new Indexer(node -> AbstractGraph.this.deviceCategorization = (Categorization)node.as(Categorization.class), node -> AbstractGraph.this.deviceCategorization = null, () -> AbstractGraph.this.deviceCategorization = null));
                this.put("Cesar#default", new Indexer(node -> AbstractGraph.this.default$ = (NameSpace)node.as(NameSpace.class), node -> AbstractGraph.this.default$ = null, () -> AbstractGraph.this.default$ = null));
                this.put("Cesar#palette", new Indexer(node -> AbstractGraph.this.palette = (Palette)node.as(Palette.class), node -> AbstractGraph.this.palette = null, () -> AbstractGraph.this.palette = null));
            }
        };
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void project(Predicate<Project> filter) {
            new ArrayList<Project>(AbstractGraph.this.projectList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void server(Predicate<Server> filter) {
            new ArrayList<Server>(AbstractGraph.this.serverList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void device(Predicate<Device> filter) {
            new ArrayList<Device>(AbstractGraph.this.deviceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void feeder(Predicate<Feeder> filter) {
            new ArrayList<Feeder>(AbstractGraph.this.feederList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void consul(Predicate<Consul> filter) {
            new ArrayList<Consul>(AbstractGraph.this.consulList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void responsible(Predicate<Responsible> filter) {
            new ArrayList<Responsible>(AbstractGraph.this.responsibleList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void emailContactResponsible(Predicate<EmailContactResponsible> filter) {
            new ArrayList<EmailContactResponsible>(AbstractGraph.this.emailContactResponsibleList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void slackContactResponsible(Predicate<SlackContactResponsible> filter) {
            new ArrayList<SlackContactResponsible>(AbstractGraph.this.slackContactResponsibleList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void deviceStatus(Predicate<DeviceStatus> filter) {
            new ArrayList<DeviceStatus>(AbstractGraph.this.deviceStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void serverStatus(Predicate<ServerStatus> filter) {
            new ArrayList<ServerStatus>(AbstractGraph.this.serverStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void feederStatus(Predicate<FeederStatus> filter) {
            new ArrayList<FeederStatus>(AbstractGraph.this.feederStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void systemStatus(Predicate<SystemStatus> filter) {
            new ArrayList<SystemStatus>(AbstractGraph.this.systemStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void deviceCrash(Predicate<DeviceCrash> filter) {
            new ArrayList<DeviceCrash>(AbstractGraph.this.deviceCrashList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void deviceBoot(Predicate<DeviceBoot> filter) {
            new ArrayList<DeviceBoot>(AbstractGraph.this.deviceBootList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Project project(String label) {
            Project newElement = (Project)((Project)AbstractGraph.this.graph.createRoot(Project.class, this.stash, this.name)).a$(Project.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Server server(String label, String ip, String url, AbstractServer.Performance performance) {
            Server newElement = (Server)((Server)AbstractGraph.this.graph.createRoot(Server.class, this.stash, this.name)).a$(Server.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "ip", Collections.singletonList(ip));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "performance", Collections.singletonList(performance));
            return newElement;
        }

        public Device device(String label) {
            Device newElement = (Device)((Device)AbstractGraph.this.graph.createRoot(Device.class, this.stash, this.name)).a$(Device.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Feeder feeder(String label, String ip, String url, AbstractServer.Performance performance) {
            Feeder newElement = (Feeder)((Feeder)AbstractGraph.this.graph.createRoot(Feeder.class, this.stash, this.name)).a$(Feeder.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "ip", Collections.singletonList(ip));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "performance", Collections.singletonList(performance));
            return newElement;
        }

        public IssueTracker issueTracker() {
            IssueTracker newElement = (IssueTracker)((IssueTracker)AbstractGraph.this.graph.createRoot(IssueTracker.class, this.stash, this.name)).a$(IssueTracker.class);
            return newElement;
        }

        public Consul consul(String version) {
            Consul newElement = (Consul)((Consul)AbstractGraph.this.graph.createRoot(Consul.class, this.stash, this.name)).a$(Consul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Responsible responsible(String label) {
            Responsible newElement = (Responsible)((Responsible)AbstractGraph.this.graph.createRoot(Responsible.class, this.stash, this.name)).a$(Responsible.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public EmailContactResponsible emailContactResponsible(String email) {
            EmailContactResponsible newElement = (EmailContactResponsible)((EmailContactResponsible)AbstractGraph.this.graph.createRoot(EmailContactResponsible.class, this.stash, this.name)).a$(EmailContactResponsible.class);
            newElement.core$().set((Layer)newElement, "email", Collections.singletonList(email));
            return newElement;
        }

        public SlackContactResponsible slackContactResponsible(String slackChannel) {
            SlackContactResponsible newElement = (SlackContactResponsible)((SlackContactResponsible)AbstractGraph.this.graph.createRoot(SlackContactResponsible.class, this.stash, this.name)).a$(SlackContactResponsible.class);
            newElement.core$().set((Layer)newElement, "slackChannel", Collections.singletonList(slackChannel));
            return newElement;
        }

        public Configuration configuration() {
            Configuration newElement = (Configuration)((Configuration)AbstractGraph.this.graph.createRoot(Configuration.class, this.stash, this.name)).a$(Configuration.class);
            return newElement;
        }

        public DeviceStatus deviceStatus(Device device, double temperature, double battery, double cpuUsage, boolean isPlugged, boolean isScreenOn, String consulVersion, Instant created) {
            DeviceStatus newElement = (DeviceStatus)((DeviceStatus)AbstractGraph.this.graph.createRoot(DeviceStatus.class, this.stash, this.name)).a$(DeviceStatus.class);
            newElement.core$().set((Layer)newElement, "device", Collections.singletonList(device));
            newElement.core$().set((Layer)newElement, "temperature", Collections.singletonList(temperature));
            newElement.core$().set((Layer)newElement, "battery", Collections.singletonList(battery));
            newElement.core$().set((Layer)newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set((Layer)newElement, "isPlugged", Collections.singletonList(isPlugged));
            newElement.core$().set((Layer)newElement, "isScreenOn", Collections.singletonList(isScreenOn));
            newElement.core$().set((Layer)newElement, "consulVersion", Collections.singletonList(consulVersion));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }

        public ServerStatus serverStatus(Server server, double cpuUsage, double memoryUsage, double diskUsage, int inboundConnections, int outboundConnections, Instant created) {
            ServerStatus newElement = (ServerStatus)((ServerStatus)AbstractGraph.this.graph.createRoot(ServerStatus.class, this.stash, this.name)).a$(ServerStatus.class);
            newElement.core$().set((Layer)newElement, "server", Collections.singletonList(server));
            newElement.core$().set((Layer)newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set((Layer)newElement, "memoryUsage", Collections.singletonList(memoryUsage));
            newElement.core$().set((Layer)newElement, "diskUsage", Collections.singletonList(diskUsage));
            newElement.core$().set((Layer)newElement, "inboundConnections", Collections.singletonList(inboundConnections));
            newElement.core$().set((Layer)newElement, "outboundConnections", Collections.singletonList(outboundConnections));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }

        public FeederStatus feederStatus(double cpuUsage, double memoryUsage, double diskUsage, int inboundConnections, int outboundConnections, Feeder server, double temperature, Instant created) {
            FeederStatus newElement = (FeederStatus)((FeederStatus)AbstractGraph.this.graph.createRoot(FeederStatus.class, this.stash, this.name)).a$(FeederStatus.class);
            newElement.core$().set((Layer)newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set((Layer)newElement, "memoryUsage", Collections.singletonList(memoryUsage));
            newElement.core$().set((Layer)newElement, "diskUsage", Collections.singletonList(diskUsage));
            newElement.core$().set((Layer)newElement, "inboundConnections", Collections.singletonList(inboundConnections));
            newElement.core$().set((Layer)newElement, "outboundConnections", Collections.singletonList(outboundConnections));
            newElement.core$().set((Layer)newElement, "server", Collections.singletonList(server));
            newElement.core$().set((Layer)newElement, "temperature", Collections.singletonList(temperature));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }

        public SystemStatus systemStatus(System system, double cpuUsage, double memoryUsage, int threads, Instant created) {
            SystemStatus newElement = (SystemStatus)((SystemStatus)AbstractGraph.this.graph.createRoot(SystemStatus.class, this.stash, this.name)).a$(SystemStatus.class);
            newElement.core$().set((Layer)newElement, "system", Collections.singletonList(system));
            newElement.core$().set((Layer)newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set((Layer)newElement, "memoryUsage", Collections.singletonList(memoryUsage));
            newElement.core$().set((Layer)newElement, "threads", Collections.singletonList(threads));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }

        public DeviceCrash deviceCrash(Device device, String app, String appVersion, String stack, String consulVersion, Instant created) {
            DeviceCrash newElement = (DeviceCrash)((DeviceCrash)AbstractGraph.this.graph.createRoot(DeviceCrash.class, this.stash, this.name)).a$(DeviceCrash.class);
            newElement.core$().set((Layer)newElement, "device", Collections.singletonList(device));
            newElement.core$().set((Layer)newElement, "app", Collections.singletonList(app));
            newElement.core$().set((Layer)newElement, "appVersion", Collections.singletonList(appVersion));
            newElement.core$().set((Layer)newElement, "stack", Collections.singletonList(stack));
            newElement.core$().set((Layer)newElement, "consulVersion", Collections.singletonList(consulVersion));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }

        public DeviceBoot deviceBoot(Device device, String consulVersion, Instant created) {
            DeviceBoot newElement = (DeviceBoot)((DeviceBoot)AbstractGraph.this.graph.createRoot(DeviceBoot.class, this.stash, this.name)).a$(DeviceBoot.class);
            newElement.core$().set((Layer)newElement, "device", Collections.singletonList(device));
            newElement.core$().set((Layer)newElement, "consulVersion", Collections.singletonList(consulVersion));
            newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
            return newElement;
        }
    }
}

