/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractAsset;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.functions.SaveImage;
import io.intino.cesar.graph.rules.Issue;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractDevice
extends Asset
implements Terminal {
    protected List<Issue> activeIssueSensors = new ArrayList<Issue>();
    protected Consul consul;
    protected Screen screen;
    protected Temperature temperature;

    public AbstractDevice(Node node) {
        super(node);
    }

    public Consul consul() {
        return this.consul;
    }

    public Screen screen() {
        return this.screen;
    }

    public Temperature temperature() {
        return this.temperature;
    }

    public Device consul(Consul value) {
        this.consul = value;
        return (Device)this;
    }

    public Device screen(Screen value) {
        this.screen = value;
        return (Device)this;
    }

    public Device temperature(Temperature value) {
        this.temperature = value;
        return (Device)this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.consul != null) {
            components.add(this.consul.core$());
        }
        if (this.screen != null) {
            components.add(this.screen.core$());
        }
        if (this.temperature != null) {
            components.add(this.temperature.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Consul")) {
            this.consul = (Consul)node.as(Consul.class);
        }
        if (node.is("Device$Screen")) {
            this.screen = (Screen)node.as(Screen.class);
        }
        if (node.is("Device$Temperature")) {
            this.temperature = (Temperature)node.as(Temperature.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Consul")) {
            this.consul = null;
        }
        if (node.is("Device$Screen")) {
            this.screen = null;
        }
        if (node.is("Device$Temperature")) {
            this.temperature = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Temperature
    extends Layer
    implements Terminal {
        protected double min;
        protected double max;

        public Temperature(Node node) {
            super(node);
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public Temperature min(double value) {
            this.min = value;
            return this;
        }

        public Temperature max(double value) {
            this.max = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("min", new ArrayList<Double>(Collections.singletonList(this.min)));
            map.put("max", new ArrayList<Double>(Collections.singletonList(this.max)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Double)values.get(0);
            }
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }
    }

    public static class Screen
    extends Layer
    implements Terminal {
        protected URL current;
        protected SaveImage save;
        protected int width;
        protected int height;

        public Screen(Node node) {
            super(node);
        }

        public URL current() {
            return this.current;
        }

        public void save(byte[] image) {
            this.save.save(image);
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Screen current(URL url, String destiny) {
            this.current = this.graph().core$().save(url, destiny, this.current, this.core$());
            return this;
        }

        public Screen current(InputStream stream, String destiny) {
            this.current = this.graph().core$().save(stream, destiny, this.current, this.core$());
            return this;
        }

        public Screen save(SaveImage value) {
            this.save = (SaveImage)FunctionLoader.load((Object)this.save, (Layer)this, SaveImage.class);
            return this;
        }

        public Screen width(int value) {
            this.width = value;
            return this;
        }

        public Screen height(int value) {
            this.height = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("current", new ArrayList<URL>(Collections.singletonList(this.current)));
            map.put("save", this.save != null ? new ArrayList<SaveImage>(Collections.singletonList(this.save)) : Collections.emptyList());
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("current")) {
                this.current = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("save")) {
                this.save = (SaveImage)FunctionLoader.load(values, (Layer)this, SaveImage.class).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("current")) {
                this.current = (URL)values.get(0);
            } else if (name.equalsIgnoreCase("save")) {
                this.save = (SaveImage)FunctionLoader.load(values.get(0), (Layer)this, SaveImage.class);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }
    }

    public class Clear {
    }

    public class Create
    extends AbstractAsset.Create {
        public Create(String name) {
            super(name);
        }

        public Consul consul(String version) {
            Consul newElement = (Consul)AbstractDevice.this.core$().graph().concept(Consul.class).createNode(this.name, AbstractDevice.this.core$()).as(Consul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Screen screen(URL current) {
            Screen newElement = (Screen)AbstractDevice.this.core$().graph().concept(Screen.class).createNode(this.name, AbstractDevice.this.core$()).as(Screen.class);
            newElement.core$().set((Layer)newElement, "current", Collections.singletonList(current));
            return newElement;
        }

        public Temperature temperature(double min, double max) {
            Temperature newElement = (Temperature)AbstractDevice.this.core$().graph().concept(Temperature.class).createNode(this.name, AbstractDevice.this.core$()).as(Temperature.class);
            newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
            newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
            return newElement;
        }

        public ServerConsul serverConsul(String version) {
            ServerConsul newElement = (ServerConsul)AbstractDevice.this.core$().graph().concept(ServerConsul.class).createNode(this.name, AbstractDevice.this.core$()).as(ServerConsul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }
    }
}

