/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures.notifications;

import io.intino.cesar.box.CesarBotSlackBot;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.notifications.Email;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Responsible;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class EventNotifier {
    protected static Logger logger = Logger.getRootLogger();
    public static boolean ACTIVE = true;
    private final CesarBotSlackBot bot;
    private final Configuration configuration;

    public EventNotifier(CesarBox box) {
        this.configuration = box.graph().configuration();
        this.bot = box.cesarBot();
    }

    public void notify(List<Responsible> responsibles, String subject, String message) {
        if (!this.configuration.notifications()) {
            return;
        }
        for (Responsible responsible : responsibles) {
            if (responsible == null) continue;
            logger.info((Object)("Message sent: " + subject));
            if (responsible.isEmailContact()) {
                Email.send(Collections.singletonList(responsible.asEmailContact().email()), subject, message);
            }
            if (!responsible.isSlackContact()) continue;
            this.notify(responsible.asSlackContact().slackChannel(), subject, message);
        }
    }

    public void notify(String slackUser, String subject, String message) {
        if (this.bot != null) {
            this.bot.sendToUser(slackUser, "*" + subject + "*: " + message);
        }
    }
}

