/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures.notifications;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

class Email {
    private static final String EMAIL_PROPERTIES = "email.properties";
    private static Logger logger = Logger.getGlobal();

    Email() {
    }

    static void send(List<String> toSend, String subject, String message) {
        try {
            if (toSend.isEmpty()) {
                return;
            }
            SimpleEmail email = new SimpleEmail();
            Email.loadConfig((org.apache.commons.mail.Email)email, toSend);
            email.setSubject(subject);
            email.setMsg(message);
            email.send();
        }
        catch (Exception e) {
            logger.severe("MailService Error: email could not be send. " + e.getClass().getSimpleName() + "(" + e.getMessage() + ")");
        }
    }

    private static void loadConfig(org.apache.commons.mail.Email email, List<String> toSend) throws EmailException {
        Properties properties = Email.loadConfiguration();
        if (properties == null) {
            return;
        }
        email.setHostName(properties.getProperty("email.hostname"));
        email.setSmtpPort(Integer.parseInt(properties.getProperty("email.port")));
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(properties.getProperty("email.user"), properties.getProperty("email.password")));
        email.setSSL(Boolean.parseBoolean(properties.getProperty("email.ssl")));
        email.setTLS(Boolean.parseBoolean(properties.getProperty("email.tls")));
        email.setFrom(properties.getProperty("email.user"), "Happysense Notification Service");
        for (String to : toSend) {
            email.addTo(to);
        }
    }

    private static Properties loadConfiguration() {
        try {
            Properties properties = new Properties();
            properties.load(Email.class.getResourceAsStream("/email.properties"));
            return properties;
        }
        catch (IOException e) {
            logger.severe("Impossible to load Email properties");
            return null;
        }
    }
}

