/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.CounterMeasure;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Identifiable;
import java.util.stream.Collectors;

public class IssueNotifier
implements CounterMeasure<Identifiable> {
    private final EventNotifier eventNotifier;
    private final CesarBox box;

    public IssueNotifier(CesarBox box) {
        this.eventNotifier = new EventNotifier(box);
        this.box = box;
    }

    @Override
    public void execute(Identifiable identifiable) {
        if (!this.box.graph().configuration().notifications()) {
            return;
        }
        this.eventNotifier.notify(identifiable.responsibles(), identifiable.label() + " has issues: " + this.subject(identifiable), this.body(identifiable));
    }

    private String subject(Identifiable identifiable) {
        return String.join((CharSequence)", ", identifiable.currentIssues().stream().map(i -> i.shortMessage(identifiable)).collect(Collectors.toList()));
    }

    private String body(Identifiable identifiable) {
        return String.join((CharSequence)"\n", identifiable.currentIssues().stream().map(i -> i.longMessage(identifiable)).collect(Collectors.toList()));
    }
}

