/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.rules.Issue;

public class SystemStatusChecker {
    private final System system;
    private final CesarBox box;

    public SystemStatusChecker(System system, CesarBox box) {
        this.system = system;
        this.box = box;
    }

    public void check() {
        if (this.system.status() == null) {
            return;
        }
        this.checkStopped();
        this.box.graph().issueTracker().save$();
    }

    private void checkStopped() {
        if (this.system.isStopped() && !this.system.currentIssues().contains((Object)Issue.Stopped)) {
            this.addIssue(Issue.Stopped);
        } else if (!this.system.isStopped()) {
            this.removeIssue(Issue.Stopped);
        }
    }

    private void removeIssue(Issue issue) {
        this.system.currentIssues().remove((Object)issue);
        this.closeIssue(issue);
        issue.resetCounterMeasures(this.box, this.system);
    }

    private void closeIssue(Issue issue) {
        this.box.graph().issueTracker().issueReportList(r -> ((Object)((Object)r.target())).equals((Object)this.system) && r.issue().equals((Object)issue)).forEach(r -> r.status(IssueReport.Status.Closed));
    }

    private void addIssue(Issue issue) {
        this.system.currentIssues().add(issue);
        issue.execCounterMeasures(this.box, this.system);
        this.createIssue(issue);
    }

    private void createIssue(Issue issue) {
        this.box.graph().issueTracker().create().issueReport(this.system, IssueReport.Level.Error, issue);
    }
}

