/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.rules.Issue;

public class ServerStatusChecker {
    private Server server;
    private final CesarBox box;

    public ServerStatusChecker(Server server, CesarBox box) {
        this.server = server;
        this.box = box;
    }

    public void check() {
        if (this.server.status() == null) {
            return;
        }
        this.checkDisconnected();
        this.checkTemperature();
        this.checkHighCPUConsume();
        this.checkHighMemoryConsume();
        this.checkLimitedHardDisk();
    }

    private void checkTemperature() {
    }

    private void checkDisconnected() {
        if (this.server.isDisconnected() && !this.server.activeIssueSensors().contains((Object)Issue.Disconnected)) {
            this.addIssue(Issue.Disconnected);
        } else if (!this.server.isDisconnected()) {
            this.removeIssue(Issue.Disconnected);
        }
    }

    private void checkHighCPUConsume() {
    }

    private void checkHighMemoryConsume() {
    }

    private void checkLimitedHardDisk() {
    }

    private void addIssue(Issue issue) {
        this.server.currentIssues().add(issue);
        this.createIssue(issue);
        issue.execCounterMeasures(this.box, this.server);
    }

    private void removeIssue(Issue issue) {
        this.server.currentIssues().remove((Object)issue);
        this.closeIssue(issue);
        issue.resetCounterMeasures(this.box, this.server);
    }

    private void closeIssue(Issue issue) {
        this.box.graph().issueTracker().issueReportList(r -> r.target() != null && ((Object)((Object)r.target())).equals((Object)this.server) && r.issue().equals((Object)issue)).forEach(r -> r.status(IssueReport.Status.Closed));
    }

    private void createIssue(Issue issue) {
        this.box.graph().issueTracker().create().issueReport(this.server, IssueReport.Level.Error, issue);
    }
}

