/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.rules.Issue;

public class FeederStatusChecker {
    private final Configuration configuration;
    private Feeder feeder;
    private final CesarBox box;

    public FeederStatusChecker(Feeder feeder, CesarBox box) {
        this.feeder = feeder;
        this.box = box;
        this.configuration = this.box.graph().configuration();
    }

    public void check() {
        if (this.feeder.status() == null) {
            return;
        }
        this.checkDisconnected();
        this.checkTemperature();
        this.checkHighCPUConsume();
        this.checkHighMemoryConsume();
        this.checkLimitedHardDisk();
        this.box.graph().issueTracker().save$();
    }

    private void checkTemperature() {
        if (this.feeder.isHot() && !this.feeder.currentIssues().contains((Object)Issue.HighTemperature)) {
            this.addIssue(Issue.HighTemperature);
        } else if (this.feeder.status().temperature() < (double)this.configuration.deviceTemperatureThreshold() && this.feeder.currentIssues().contains((Object)Issue.HighTemperature)) {
            this.removeIssue(Issue.HighTemperature);
        }
    }

    private void checkDisconnected() {
        if (this.feeder.isDisconnected() && !this.feeder.activeIssueSensors().contains((Object)Issue.Disconnected)) {
            this.addIssue(Issue.Disconnected);
        } else if (!this.feeder.isDisconnected()) {
            this.removeIssue(Issue.Disconnected);
        }
    }

    private void checkHighCPUConsume() {
    }

    private void checkHighMemoryConsume() {
    }

    private void checkLimitedHardDisk() {
    }

    private void addIssue(Issue issue) {
        this.feeder.currentIssues().add(issue);
        this.registerIssue(issue);
        issue.execCounterMeasures(this.box, this.feeder);
    }

    private void removeIssue(Issue issue) {
        this.feeder.currentIssues().remove((Object)issue);
        this.closeIssue(issue);
        issue.resetCounterMeasures(this.box, this.feeder);
    }

    private void registerIssue(Issue issue) {
        this.box.graph().issueTracker().create().issueReport(this.feeder, IssueReport.Level.Error, issue);
    }

    private void closeIssue(Issue issue) {
        this.box.graph().issueTracker().issueReportList(r -> ((Object)((Object)r.target())).equals((Object)this.feeder) && r.issue().equals((Object)issue)).forEach(r -> r.status(IssueReport.Status.Closed));
    }
}

