/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.rules.Issue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceStatusChecker {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private Device device;
    private final CesarBox box;
    private final Configuration configuration;

    public DeviceStatusChecker(Device device, CesarBox box) {
        this.box = box;
        this.device = device;
        this.configuration = box.graph().configuration();
    }

    public void check() {
        this.checkDisconnected();
        if (this.device.status() == null || this.configuration == null) {
            this.save();
            return;
        }
        this.checkUnplug();
        this.checkLowBattery();
        this.checkHighTemperature();
        this.checkVeryLowBattery();
        this.checkScreen();
        this.save();
    }

    private void save() {
        this.device.core$().save();
        this.box.graph().issueTracker().save$();
    }

    private void checkUnplug() {
        if (this.device.isUnPlugged() && !this.device.currentIssues().contains((Object)Issue.Unplugged)) {
            this.addIssue(Issue.Unplugged);
        } else if (!this.device.isUnPlugged()) {
            this.removeIssue(Issue.Unplugged);
        }
    }

    private void checkLowBattery() {
        if (this.device.lowBattery() && !this.device.currentIssues().contains((Object)Issue.LowBattery)) {
            this.addIssue(Issue.LowBattery);
        } else if (this.device.status().battery() >= (double)this.configuration.deviceBatteryThreshold()) {
            this.removeIssue(Issue.LowBattery);
        }
    }

    private void checkHighTemperature() {
        if (this.device.isHot() && !this.device.currentIssues().contains((Object)Issue.HighTemperature)) {
            this.addIssue(Issue.HighTemperature);
        } else if (this.device.status().temperature() < (double)this.configuration.deviceTemperatureThreshold() && this.device.currentIssues().contains((Object)Issue.HighTemperature)) {
            this.removeIssue(Issue.HighTemperature);
        }
    }

    private void checkVeryLowBattery() {
        if (this.device.veryLowBattery() && !this.device.currentIssues().contains((Object)Issue.VeryLowBattery)) {
            this.addIssue(Issue.VeryLowBattery);
        } else if (!this.device.veryLowBattery()) {
            this.removeIssue(Issue.VeryLowBattery);
        }
    }

    private void checkDisconnected() {
        if (this.device.isDisconnected() && !this.device.currentIssues().contains((Object)Issue.Disconnected)) {
            this.addIssue(Issue.Disconnected);
        } else if (!this.device.isDisconnected()) {
            this.removeIssue(Issue.Disconnected);
        }
    }

    private void checkScreen() {
        if (!this.device.status().isScreenOn()) {
            return;
        }
        if (!this.isCorrect()) {
            this.addIssue(Issue.Misconfigured);
        } else {
            this.removeIssue(Issue.Misconfigured);
        }
    }

    private void addIssue(Issue issue) {
        this.device.currentIssues().add(issue);
        this.createIssueReport(issue);
        issue.execCounterMeasures(this.box, this.device);
    }

    private void createIssueReport(Issue issue) {
        this.box.graph().issueTracker().create().issueReport(this.device, IssueReport.Level.Error, issue);
    }

    private void removeIssue(Issue issue) {
        this.device.currentIssues().remove((Object)issue);
        this.closeIssue(issue);
        issue.resetCounterMeasures(this.box, this.device);
    }

    private void closeIssue(Issue issue) {
        this.box.graph().issueTracker().issueReportList(r -> ((Object)((Object)r.target())).equals((Object)this.device) && r.issue().equals((Object)issue)).forEach(r -> r.status(IssueReport.Status.Closed));
    }

    private boolean isCorrect() {
        return true;
    }
}

