/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack.helpers;

import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.FeederStatus;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemStatus;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class SlackMessageFormatter {
    private static final String NO_STATUS = "no status";
    private static final DecimalFormat df = new DecimalFormat("0.0#");

    public static String format(Device device, String timeZone) {
        DeviceStatus status = device.status();
        return status == null ? NO_STATUS : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + SlackMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :hammer_and_pick:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + SlackMessageFormatter.state(status.isScreenOn()) + "`   " + SlackMessageFormatter.time(status.created(), timeZone, device.isDisconnected());
    }

    public static String format(Status status, String timeZone) {
        return status == null ? NO_STATUS : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + SlackMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :hammer_and_pick:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + SlackMessageFormatter.state(status.isScreenOn()) + "`   " + SlackMessageFormatter.time(status.ts() == null ? Instant.now() : status.ts(), timeZone);
    }

    public static String format(Server server, String timeZone) {
        ServerStatus status = server.status();
        StringBuilder builder = new StringBuilder();
        builder.append("> ");
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        if (server.isDisconnected()) {
            return SlackMessageFormatter.formatDisconnected(builder, status.created(), timeZone).toString();
        }
        builder.append(SlackMessageFormatter.cpu(status.cpuUsage()));
        if (status instanceof FeederStatus) {
            builder.append("   ").append(SlackMessageFormatter.temperature(((FeederStatus)status).temperature()));
        }
        builder.append("   ").append(SlackMessageFormatter.memory(status.memoryUsage())).append("   ").append(SlackMessageFormatter.hdd(status.diskUsage())).append("   ").append(SlackMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append("   ").append(SlackMessageFormatter.time(status.created(), timeZone, server.isDisconnected()));
        return builder.toString();
    }

    public static String format(ServerStatus status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        builder.append("> ");
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        builder.append("\n\t");
        if (status instanceof FeederStatus) {
            builder.append(SlackMessageFormatter.temperature(((FeederStatus)status).temperature()));
        }
        return builder.append("   ").append(SlackMessageFormatter.cpu(status.cpuUsage())).append("   ").append(SlackMessageFormatter.memory(status.memoryUsage())).append("   ").append(SlackMessageFormatter.hdd(status.diskUsage())).append("   ").append(SlackMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append("   ").append(SlackMessageFormatter.time(status.created(), timeZone)).toString();
    }

    public static String format(io.intino.consul.schemas.ServerStatus status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        return builder.append("\n\t").append(SlackMessageFormatter.cpu(status.cpu())).append("   ").append(SlackMessageFormatter.memory(status.memory())).append("   ").append(SlackMessageFormatter.hdd(status.hdd())).append("   ").append(SlackMessageFormatter.temperature(status.temperature())).append("   ").append(SlackMessageFormatter.connections(status.inboundConnections().intValue(), status.outboundConnections().intValue())).append("   ").append(SlackMessageFormatter.time(status.ts(), timeZone)).toString();
    }

    private static String time(Instant instant, String timeZone, boolean disconnected) {
        return (disconnected ? ":disconnected:" : ":clock10:") + "`" + SlackMessageFormatter.formatInstant(timeZone, instant) + "`";
    }

    private static String time(Instant instant, String timeZone) {
        return ":clock10:`" + SlackMessageFormatter.formatInstant(timeZone, instant) + "`";
    }

    public static String format(io.intino.consul.schemas.SystemStatus status, String timeZone) {
        String result = "\n\t";
        if (status == null || !status.started().booleanValue()) {
            return result + NO_STATUS;
        }
        return result + SlackMessageFormatter.cpu(status.cpu()) + " " + SlackMessageFormatter.memoryInAmount(status.memory()) + " " + SlackMessageFormatter.threads(status.threads()) + " " + SlackMessageFormatter.time(status.ts(), timeZone);
    }

    public static String format(System system, String timeZone) {
        String result = "\n\t";
        SystemStatus status = system.status();
        if (status == null) {
            return result + NO_STATUS;
        }
        return result + SlackMessageFormatter.cpu(status.cpuUsage()) + " " + SlackMessageFormatter.memoryInAmount(status.memoryUsage()) + " " + SlackMessageFormatter.threads(status.threads()) + " " + SlackMessageFormatter.time(status.created(), timeZone);
    }

    public static String formatCompromised(Device device, String timeZone) {
        DeviceStatus status = device.status();
        DecimalFormat df = new DecimalFormat("0.0#");
        StringBuilder builder = new StringBuilder();
        if (device.status() == null) {
            return SlackMessageFormatter.noData(builder).toString();
        }
        if (device.isDisconnected()) {
            return SlackMessageFormatter.formatDisconnected(builder, status.created(), timeZone).toString();
        }
        if (device.lowBattery()) {
            builder.append(":battery:`").append(df.format(status.battery())).append("`   ");
        }
        if (device.isUnPlugged()) {
            builder.append(":electric_plug:`").append(SlackMessageFormatter.state(status.isPlugged())).append("`   ");
        }
        if (device.isHot()) {
            builder.append(":thermometer:`").append(df.format(status.temperature())).append("`   ");
        }
        if (!status.isScreenOn()) {
            builder.append(":desktop_computer:`").append(SlackMessageFormatter.state(status.isScreenOn())).append("`   ");
        }
        builder.append(SlackMessageFormatter.time(status.created(), timeZone, device.isDisconnected()));
        return builder.toString();
    }

    public static String formatCompromised(Server server, String timeZone) {
        ServerStatus status = server.status();
        StringBuilder builder = new StringBuilder();
        if (server.status() == null) {
            return SlackMessageFormatter.noData(builder).toString();
        }
        if (server.isDisconnected()) {
            return SlackMessageFormatter.formatDisconnected(builder, status.created(), timeZone).toString();
        }
        if (server.isRunningOutOfMemory()) {
            builder.append(SlackMessageFormatter.hdd(status.diskUsage())).append("`   ");
        }
        if (server.isRunningOutOfDisk()) {
            builder.append(SlackMessageFormatter.memory(status.memoryUsage())).append("`   ");
        }
        builder.append(SlackMessageFormatter.time(status.created(), timeZone, server.isDisconnected()));
        return builder.toString();
    }

    private static StringBuilder noData(StringBuilder builder) {
        return builder.append("`Disconnected. No data`");
    }

    private static StringBuilder formatDisconnected(StringBuilder builder, Instant ts, String timeZone) {
        return builder.append("\tDisconnected since ").append("`").append(SlackMessageFormatter.formatInstant(timeZone, ts)).append("`");
    }

    public static String formatInstant(String timeZone, Instant instant) {
        return DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.of(timeZone)).format(instant);
    }

    private static String temperature(double temperature) {
        return temperature == 0.0 ? "" : ":thermometer:`" + df.format(temperature) + "\u00ba`";
    }

    private static String hdd(double value) {
        return ":harddisk:`" + df.format(value) + "%`";
    }

    private static String memory(double value) {
        return ":memory:`" + df.format(value) + "%`";
    }

    private static String memoryInAmount(double value) {
        return ":memory:`" + df.format(value) + "mb`";
    }

    private static String connections(double in, double out) {
        return ":network: (`" + in + "`:small_red_triangle_down: `" + out + "`:small_red_triangle:)";
    }

    private static String cpu(double value) {
        return ":hammer_and_pick: `" + df.format(value) + "%`";
    }

    private static String threads(int value) {
        return ":threads: `" + value + "`";
    }

    private static String state(boolean state) {
        return state ? "ON" : "OFF";
    }
}

